@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountSkuResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountSkuResponse.Companion.toKotlin as integrationAccountSkuResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin

/**
 * Builder for [IntegrationAccount].
 */
@PulumiTagMarker
public class IntegrationAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountArgs = IntegrationAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationAccount {
        val builtJavaResource = com.pulumi.azurenative.logic.IntegrationAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationAccount(builtJavaResource)
    }
}

/**
 * The integration account.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update an integration account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccount = new AzureNative.Logic.IntegrationAccount("integrationAccount", new()
 *     {
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         ResourceGroupName = "testResourceGroup",
 *         Sku = new AzureNative.Logic.Inputs.IntegrationAccountSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccount(ctx, "integrationAccount", &logic.IntegrationAccountArgs{
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			Sku: &logic.IntegrationAccountSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccount;
 * import com.pulumi.azurenative.logic.IntegrationAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccount = new IntegrationAccount("integrationAccount", IntegrationAccountArgs.builder()
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .resourceGroupName("testResourceGroup")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccount testIntegrationAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}
 * ```
 */
public class IntegrationAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccount,
) : KotlinCustomResource(javaResource, IntegrationAccountMapper) {
    /**
     * The integration service environment.
     */
    public val integrationServiceEnvironment: Output<ResourceReferenceResponse>?
        get() = javaResource.integrationServiceEnvironment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The sku.
     */
    public val sku: Output<IntegrationAccountSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    integrationAccountSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The workflow state.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountMapper : ResourceMapper<IntegrationAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccount::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccount = IntegrationAccount(
        javaResource as
            com.pulumi.azurenative.logic.IntegrationAccount,
    )
}

/**
 * @see [IntegrationAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccount].
 */
public suspend fun integrationAccount(
    name: String,
    block: suspend IntegrationAccountResourceBuilder.() -> Unit,
): IntegrationAccount {
    val builder = IntegrationAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccount(name: String): IntegrationAccount {
    val builder = IntegrationAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
