@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.BatchConfigurationPropertiesArgs
import com.pulumi.azurenative.logic.kotlin.inputs.BatchConfigurationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The batch configuration resource definition.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update a batch configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountBatchConfiguration = new AzureNative.Logic.IntegrationAccountBatchConfiguration("integrationAccountBatchConfiguration", new()
 *     {
 *         BatchConfigurationName = "testBatchConfiguration",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Properties = new AzureNative.Logic.Inputs.BatchConfigurationPropertiesArgs
 *         {
 *             BatchGroupName = "DEFAULT",
 *             ReleaseCriteria = new AzureNative.Logic.Inputs.BatchReleaseCriteriaArgs
 *             {
 *                 BatchSize = 234567,
 *                 MessageCount = 10,
 *                 Recurrence = new AzureNative.Logic.Inputs.WorkflowTriggerRecurrenceArgs
 *                 {
 *                     Frequency = "Minute",
 *                     Interval = 1,
 *                     StartTime = "2017-03-24T11:43:00",
 *                     TimeZone = "India Standard Time",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := logic.NewIntegrationAccountBatchConfiguration(ctx, "integrationAccountBatchConfiguration", &logic.IntegrationAccountBatchConfigurationArgs{
 * BatchConfigurationName: pulumi.String("testBatchConfiguration"),
 * IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * Location: pulumi.String("westus"),
 * Properties: logic.BatchConfigurationPropertiesResponse{
 * BatchGroupName: pulumi.String("DEFAULT"),
 * ReleaseCriteria: interface{}{
 * BatchSize: pulumi.Int(234567),
 * MessageCount: pulumi.Int(10),
 * Recurrence: &logic.WorkflowTriggerRecurrenceArgs{
 * Frequency: pulumi.String("Minute"),
 * Interval: pulumi.Int(1),
 * StartTime: pulumi.String("2017-03-24T11:43:00"),
 * TimeZone: pulumi.String("India Standard Time"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("testResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration;
 * import com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountBatchConfiguration = new IntegrationAccountBatchConfiguration("integrationAccountBatchConfiguration", IntegrationAccountBatchConfigurationArgs.builder()
 *             .batchConfigurationName("testBatchConfiguration")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("batchGroupName", "DEFAULT"),
 *                 Map.entry("releaseCriteria", Map.ofEntries(
 *                     Map.entry("batchSize", 234567),
 *                     Map.entry("messageCount", 10),
 *                     Map.entry("recurrence", Map.ofEntries(
 *                         Map.entry("frequency", "Minute"),
 *                         Map.entry("interval", 1),
 *                         Map.entry("startTime", "2017-03-24T11:43:00"),
 *                         Map.entry("timeZone", "India Standard Time")
 *                     ))
 *                 ))
 *             ))
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountBatchConfiguration testBatchConfiguration /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations/{batchConfigurationName}
 * ```
 * @property batchConfigurationName The batch configuration name.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property properties The batch configuration properties.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountBatchConfigurationArgs(
    public val batchConfigurationName: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<BatchConfigurationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs =
        com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs.builder()
            .batchConfigurationName(batchConfigurationName?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountBatchConfigurationArgs].
 */
@PulumiTagMarker
public class IntegrationAccountBatchConfigurationArgsBuilder internal constructor() {
    private var batchConfigurationName: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<BatchConfigurationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The batch configuration name.
     */
    @JvmName("eagnukxabjwbioxw")
    public suspend fun batchConfigurationName(`value`: Output<String>) {
        this.batchConfigurationName = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("axonnmdhfkvedwbh")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("bxbwhvsijcgnpquk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The batch configuration properties.
     */
    @JvmName("jbjtbvshveibveui")
    public suspend fun properties(`value`: Output<BatchConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vxfnbkcgcctamnrx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("jdaluhavgrmfdmdh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The batch configuration name.
     */
    @JvmName("ufskoikulwmjurcj")
    public suspend fun batchConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchConfigurationName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("jbtsyfxjomkpufit")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("rxcbvlnqptjgiwxb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The batch configuration properties.
     */
    @JvmName("niwycjfebfyinukm")
    public suspend fun properties(`value`: BatchConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The batch configuration properties.
     */
    @JvmName("lcjrwgooosxvheox")
    public suspend
    fun properties(argument: suspend BatchConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BatchConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ichvxykmeinvneis")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("jjjechshcjoccmbo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("lvqhbdackyvugxgg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountBatchConfigurationArgs =
        IntegrationAccountBatchConfigurationArgs(
            batchConfigurationName = batchConfigurationName,
            integrationAccountName = integrationAccountName,
            location = location,
            properties = properties,
            resourceGroupName = resourceGroupName,
            tags = tags,
        )
}
