@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationAccountSchema].
 */
@PulumiTagMarker
public class IntegrationAccountSchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountSchemaArgs = IntegrationAccountSchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountSchemaArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountSchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationAccountSchema {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountSchema(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountSchema(builtJavaResource)
    }
}

/**
 * The integration account schema.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update schema
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountSchema = new AzureNative.Logic.IntegrationAccountSchema("integrationAccountSchema", new()
 *     {
 *         Content = @"<?xml version=""1.0"" encoding=""utf-16""?>
 * <xs:schema xmlns:b=""http://schemas.microsoft.com/BizTalk/2003"" xmlns=""http://Inbound_EDI.OrderFile"" targetNamespace=""http://Inbound_EDI.OrderFile"" xmlns:xs=""http://www.w3.org/2001/XMLSchema"">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char="" "" count_positions_by_byte=""false"" parser_optimization=""speed"" lookahead_depth=""3"" suppress_empty_nodes=""false"" generate_empty_nodes=""true"" allow_early_termination=""false"" early_terminate_optional_fields=""false"" allow_message_breakup_of_infix_root=""false"" compile_parse_tables=""false"" standard=""Flat File"" root_reference=""OrderFile"" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias=""b"" extensionClass=""Microsoft.BizTalk.FlatFileExtension.FlatFileExtension"" standardName=""Flat File"" xmlns:schemaEditorExtension=""http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions"" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name=""OrderFile"">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" sequence_number=""1"" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number=""0"" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name=""Order"">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number=""1"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""hex"" child_delimiter=""0x0D 0x0A"" child_order=""infix"" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number=""0"" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name=""Header"">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number=""1"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""char"" child_delimiter=""|"" child_order=""infix"" tag_name=""HDR|"" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number=""0"" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name=""PODate"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""1"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""PONumber"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification=""left"" sequence_number=""2"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerID"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""3"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerContactName"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""4"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""CustomerContactPhone"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""5"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs=""1"" maxOccurs=""unbounded"" name=""LineItems"">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number=""2"" structure=""delimited"" preserve_delimiter_for_empty_data=""true"" suppress_trailing_delimiters=""false"" child_delimiter_type=""char"" child_delimiter=""|"" child_order=""infix"" tag_name=""DTL|"" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number=""0"" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name=""PONumber"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""1"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""ItemOrdered"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""2"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Quantity"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""3"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""UOM"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""4"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Price"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""5"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""ExtendedPrice"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""6"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name=""Description"" type=""xs:string"">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number=""7"" justification=""left"" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>",
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *         SchemaName = "testSchema",
 *         SchemaType = "Xml",
 *         Tags =
 *         {
 *             { "integrationAccountSchemaName", "IntegrationAccountSchema8120" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountSchema(ctx, "integrationAccountSchema", &logic.IntegrationAccountSchemaArgs{
 * 			Content: pulumi.String(`<?xml version="1.0" encoding="utf-16"?>
 * <xs:schema xmlns:b="http://schemas.microsoft.com/BizTalk/2003" xmlns="http://Inbound_EDI.OrderFile" targetNamespace="http://Inbound_EDI.OrderFile" xmlns:xs="http://www.w3.org/2001/XMLSchema">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char=" " count_positions_by_byte="false" parser_optimization="speed" lookahead_depth="3" suppress_empty_nodes="false" generate_empty_nodes="true" allow_early_termination="false" early_terminate_optional_fields="false" allow_message_breakup_of_infix_root="false" compile_parse_tables="false" standard="Flat File" root_reference="OrderFile" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias="b" extensionClass="Microsoft.BizTalk.FlatFileExtension.FlatFileExtension" standardName="Flat File" xmlns:schemaEditorExtension="http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name="OrderFile">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" sequence_number="1" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number="0" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name="Order">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="hex" child_delimiter="0x0D 0x0A" child_order="infix" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number="0" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name="Header">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="HDR|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PODate" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification="left" sequence_number="2" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerID" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactName" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactPhone" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs="1" maxOccurs="unbounded" name="LineItems">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="2" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="DTL|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ItemOrdered" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="2" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Quantity" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="UOM" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Price" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ExtendedPrice" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="6" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Description" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="7" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>`),
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Metadata:               nil,
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			SchemaName:             pulumi.String("testSchema"),
 * 			SchemaType:             pulumi.String("Xml"),
 * 			Tags: pulumi.StringMap{
 * 				"integrationAccountSchemaName": pulumi.String("IntegrationAccountSchema8120"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountSchema;
 * import com.pulumi.azurenative.logic.IntegrationAccountSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountSchema = new IntegrationAccountSchema("integrationAccountSchema", IntegrationAccountSchemaArgs.builder()
 *             .content("""
 * <?xml version="1.0" encoding="utf-16"?>
 * <xs:schema xmlns:b="http://schemas.microsoft.com/BizTalk/2003" xmlns="http://Inbound_EDI.OrderFile" targetNamespace="http://Inbound_EDI.OrderFile" xmlns:xs="http://www.w3.org/2001/XMLSchema">
 *   <xs:annotation>
 *     <xs:appinfo>
 *       <b:schemaInfo default_pad_char=" " count_positions_by_byte="false" parser_optimization="speed" lookahead_depth="3" suppress_empty_nodes="false" generate_empty_nodes="true" allow_early_termination="false" early_terminate_optional_fields="false" allow_message_breakup_of_infix_root="false" compile_parse_tables="false" standard="Flat File" root_reference="OrderFile" />
 *       <schemaEditorExtension:schemaInfo namespaceAlias="b" extensionClass="Microsoft.BizTalk.FlatFileExtension.FlatFileExtension" standardName="Flat File" xmlns:schemaEditorExtension="http://schemas.microsoft.com/BizTalk/2003/SchemaEditorExtensions" />
 *     </xs:appinfo>
 *   </xs:annotation>
 *   <xs:element name="OrderFile">
 *     <xs:annotation>
 *       <xs:appinfo>
 *         <b:recordInfo structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" sequence_number="1" />
 *       </xs:appinfo>
 *     </xs:annotation>
 *     <xs:complexType>
 *       <xs:sequence>
 *         <xs:annotation>
 *           <xs:appinfo>
 *             <b:groupInfo sequence_number="0" />
 *           </xs:appinfo>
 *         </xs:annotation>
 *         <xs:element name="Order">
 *           <xs:annotation>
 *             <xs:appinfo>
 *               <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="hex" child_delimiter="0x0D 0x0A" child_order="infix" />
 *             </xs:appinfo>
 *           </xs:annotation>
 *           <xs:complexType>
 *             <xs:sequence>
 *               <xs:annotation>
 *                 <xs:appinfo>
 *                   <b:groupInfo sequence_number="0" />
 *                 </xs:appinfo>
 *               </xs:annotation>
 *               <xs:element name="Header">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="1" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="HDR|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PODate" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo justification="left" sequence_number="2" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerID" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactName" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="CustomerContactPhone" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *               <xs:element minOccurs="1" maxOccurs="unbounded" name="LineItems">
 *                 <xs:annotation>
 *                   <xs:appinfo>
 *                     <b:recordInfo sequence_number="2" structure="delimited" preserve_delimiter_for_empty_data="true" suppress_trailing_delimiters="false" child_delimiter_type="char" child_delimiter="|" child_order="infix" tag_name="DTL|" />
 *                   </xs:appinfo>
 *                 </xs:annotation>
 *                 <xs:complexType>
 *                   <xs:sequence>
 *                     <xs:annotation>
 *                       <xs:appinfo>
 *                         <b:groupInfo sequence_number="0" />
 *                       </xs:appinfo>
 *                     </xs:annotation>
 *                     <xs:element name="PONumber" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="1" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ItemOrdered" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="2" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Quantity" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="3" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="UOM" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="4" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Price" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="5" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="ExtendedPrice" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="6" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                     <xs:element name="Description" type="xs:string">
 *                       <xs:annotation>
 *                         <xs:appinfo>
 *                           <b:fieldInfo sequence_number="7" justification="left" />
 *                         </xs:appinfo>
 *                       </xs:annotation>
 *                     </xs:element>
 *                   </xs:sequence>
 *                 </xs:complexType>
 *               </xs:element>
 *             </xs:sequence>
 *           </xs:complexType>
 *         </xs:element>
 *       </xs:sequence>
 *     </xs:complexType>
 *   </xs:element>
 * </xs:schema>            """)
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .schemaName("testSchema")
 *             .schemaType("Xml")
 *             .tags(Map.of("integrationAccountSchemaName", "IntegrationAccountSchema8120"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountSchema IntegrationAccountSchema5349 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}
 * ```
 */
public class IntegrationAccountSchema internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountSchema,
) : KotlinCustomResource(javaResource, IntegrationAccountSchemaMapper) {
    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The content.
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The content link.
     */
    public val contentLink: Output<ContentLinkResponse>
        get() = javaResource.contentLink().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The content type.
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The document name.
     */
    public val documentName: Output<String>?
        get() = javaResource.documentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The file name.
     */
    public val fileName: Output<String>?
        get() = javaResource.fileName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The schema type.
     */
    public val schemaType: Output<String>
        get() = javaResource.schemaType().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The target namespace of the schema.
     */
    public val targetNamespace: Output<String>?
        get() = javaResource.targetNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountSchemaMapper : ResourceMapper<IntegrationAccountSchema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountSchema::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountSchema =
        IntegrationAccountSchema(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountSchema,
        )
}

/**
 * @see [IntegrationAccountSchema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountSchema].
 */
public suspend fun integrationAccountSchema(
    name: String,
    block: suspend IntegrationAccountSchemaResourceBuilder.() -> Unit,
): IntegrationAccountSchema {
    val builder = IntegrationAccountSchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountSchema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountSchema(name: String): IntegrationAccountSchema {
    val builder = IntegrationAccountSchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
