@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account AS2 agreement content.
 * @property receiveAgreement The AS2 one-way receive agreement.
 * @property sendAgreement The AS2 one-way send agreement.
 */
public data class AS2AgreementContentArgs(
    public val receiveAgreement: Output<AS2OneWayAgreementArgs>,
    public val sendAgreement: Output<AS2OneWayAgreementArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs =
        com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs.builder()
            .receiveAgreement(receiveAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sendAgreement(sendAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AS2AgreementContentArgs].
 */
@PulumiTagMarker
public class AS2AgreementContentArgsBuilder internal constructor() {
    private var receiveAgreement: Output<AS2OneWayAgreementArgs>? = null

    private var sendAgreement: Output<AS2OneWayAgreementArgs>? = null

    /**
     * @param value The AS2 one-way receive agreement.
     */
    @JvmName("mhvidobxxuwthjau")
    public suspend fun receiveAgreement(`value`: Output<AS2OneWayAgreementArgs>) {
        this.receiveAgreement = value
    }

    /**
     * @param value The AS2 one-way send agreement.
     */
    @JvmName("rgbmcipactlrwfcd")
    public suspend fun sendAgreement(`value`: Output<AS2OneWayAgreementArgs>) {
        this.sendAgreement = value
    }

    /**
     * @param value The AS2 one-way receive agreement.
     */
    @JvmName("uoaiecehqpdwieyf")
    public suspend fun receiveAgreement(`value`: AS2OneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiveAgreement = mapped
    }

    /**
     * @param argument The AS2 one-way receive agreement.
     */
    @JvmName("crmuxbktrrsmbgfj")
    public suspend fun receiveAgreement(argument: suspend AS2OneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = AS2OneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiveAgreement = mapped
    }

    /**
     * @param value The AS2 one-way send agreement.
     */
    @JvmName("disowmbxjdpcdutp")
    public suspend fun sendAgreement(`value`: AS2OneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendAgreement = mapped
    }

    /**
     * @param argument The AS2 one-way send agreement.
     */
    @JvmName("wimxmlsermrfyqqo")
    public suspend fun sendAgreement(argument: suspend AS2OneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = AS2OneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sendAgreement = mapped
    }

    internal fun build(): AS2AgreementContentArgs = AS2AgreementContentArgs(
        receiveAgreement = receiveAgreement ?: throw PulumiNullFieldException("receiveAgreement"),
        sendAgreement = sendAgreement ?: throw PulumiNullFieldException("sendAgreement"),
    )
}
