@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement message connection settings.
 * @property ignoreCertificateNameMismatch The value indicating whether to ignore mismatch in certificate name.
 * @property keepHttpConnectionAlive The value indicating whether to keep the connection alive.
 * @property supportHttpStatusCodeContinue The value indicating whether to support HTTP status code 'CONTINUE'.
 * @property unfoldHttpHeaders The value indicating whether to unfold the HTTP headers.
 */
public data class AS2MessageConnectionSettingsArgs(
    public val ignoreCertificateNameMismatch: Output<Boolean>,
    public val keepHttpConnectionAlive: Output<Boolean>,
    public val supportHttpStatusCodeContinue: Output<Boolean>,
    public val unfoldHttpHeaders: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs.builder()
            .ignoreCertificateNameMismatch(ignoreCertificateNameMismatch.applyValue({ args0 -> args0 }))
            .keepHttpConnectionAlive(keepHttpConnectionAlive.applyValue({ args0 -> args0 }))
            .supportHttpStatusCodeContinue(supportHttpStatusCodeContinue.applyValue({ args0 -> args0 }))
            .unfoldHttpHeaders(unfoldHttpHeaders.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2MessageConnectionSettingsArgs].
 */
@PulumiTagMarker
public class AS2MessageConnectionSettingsArgsBuilder internal constructor() {
    private var ignoreCertificateNameMismatch: Output<Boolean>? = null

    private var keepHttpConnectionAlive: Output<Boolean>? = null

    private var supportHttpStatusCodeContinue: Output<Boolean>? = null

    private var unfoldHttpHeaders: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to ignore mismatch in certificate name.
     */
    @JvmName("uupqkxqjuamnxflg")
    public suspend fun ignoreCertificateNameMismatch(`value`: Output<Boolean>) {
        this.ignoreCertificateNameMismatch = value
    }

    /**
     * @param value The value indicating whether to keep the connection alive.
     */
    @JvmName("vrflkqhcjblflhij")
    public suspend fun keepHttpConnectionAlive(`value`: Output<Boolean>) {
        this.keepHttpConnectionAlive = value
    }

    /**
     * @param value The value indicating whether to support HTTP status code 'CONTINUE'.
     */
    @JvmName("oclyvfnemggcybdx")
    public suspend fun supportHttpStatusCodeContinue(`value`: Output<Boolean>) {
        this.supportHttpStatusCodeContinue = value
    }

    /**
     * @param value The value indicating whether to unfold the HTTP headers.
     */
    @JvmName("gfhfpiajkbcqrdox")
    public suspend fun unfoldHttpHeaders(`value`: Output<Boolean>) {
        this.unfoldHttpHeaders = value
    }

    /**
     * @param value The value indicating whether to ignore mismatch in certificate name.
     */
    @JvmName("yfmxxjnpkiaefqvv")
    public suspend fun ignoreCertificateNameMismatch(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreCertificateNameMismatch = mapped
    }

    /**
     * @param value The value indicating whether to keep the connection alive.
     */
    @JvmName("nulpuiwsdlpehmse")
    public suspend fun keepHttpConnectionAlive(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keepHttpConnectionAlive = mapped
    }

    /**
     * @param value The value indicating whether to support HTTP status code 'CONTINUE'.
     */
    @JvmName("efafhnfqxsbxhxlr")
    public suspend fun supportHttpStatusCodeContinue(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportHttpStatusCodeContinue = mapped
    }

    /**
     * @param value The value indicating whether to unfold the HTTP headers.
     */
    @JvmName("pyrsypcjijlyeuco")
    public suspend fun unfoldHttpHeaders(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unfoldHttpHeaders = mapped
    }

    internal fun build(): AS2MessageConnectionSettingsArgs = AS2MessageConnectionSettingsArgs(
        ignoreCertificateNameMismatch = ignoreCertificateNameMismatch ?: throw
            PulumiNullFieldException("ignoreCertificateNameMismatch"),
        keepHttpConnectionAlive = keepHttpConnectionAlive ?: throw
            PulumiNullFieldException("keepHttpConnectionAlive"),
        supportHttpStatusCodeContinue = supportHttpStatusCodeContinue ?: throw
            PulumiNullFieldException("supportHttpStatusCodeContinue"),
        unfoldHttpHeaders = unfoldHttpHeaders ?: throw PulumiNullFieldException("unfoldHttpHeaders"),
    )
}
