@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The AS2 agreement protocol settings.
 * @property acknowledgementConnectionSettings The acknowledgement connection settings.
 * @property envelopeSettings The envelope settings.
 * @property errorSettings The error settings.
 * @property mdnSettings The MDN settings.
 * @property messageConnectionSettings The message connection settings.
 * @property securitySettings The security settings.
 * @property validationSettings The validation settings.
 */
public data class AS2ProtocolSettingsArgs(
    public val acknowledgementConnectionSettings: Output<AS2AcknowledgementConnectionSettingsArgs>,
    public val envelopeSettings: Output<AS2EnvelopeSettingsArgs>,
    public val errorSettings: Output<AS2ErrorSettingsArgs>,
    public val mdnSettings: Output<AS2MdnSettingsArgs>,
    public val messageConnectionSettings: Output<AS2MessageConnectionSettingsArgs>,
    public val securitySettings: Output<AS2SecuritySettingsArgs>,
    public val validationSettings: Output<AS2ValidationSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs.builder()
            .acknowledgementConnectionSettings(
                acknowledgementConnectionSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .envelopeSettings(envelopeSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .errorSettings(errorSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mdnSettings(mdnSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageConnectionSettings(
                messageConnectionSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securitySettings(securitySettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationSettings(
                validationSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AS2ProtocolSettingsArgs].
 */
@PulumiTagMarker
public class AS2ProtocolSettingsArgsBuilder internal constructor() {
    private var acknowledgementConnectionSettings: Output<AS2AcknowledgementConnectionSettingsArgs>? =
        null

    private var envelopeSettings: Output<AS2EnvelopeSettingsArgs>? = null

    private var errorSettings: Output<AS2ErrorSettingsArgs>? = null

    private var mdnSettings: Output<AS2MdnSettingsArgs>? = null

    private var messageConnectionSettings: Output<AS2MessageConnectionSettingsArgs>? = null

    private var securitySettings: Output<AS2SecuritySettingsArgs>? = null

    private var validationSettings: Output<AS2ValidationSettingsArgs>? = null

    /**
     * @param value The acknowledgement connection settings.
     */
    @JvmName("mcpldxhhfeuckvhj")
    public suspend
    fun acknowledgementConnectionSettings(`value`: Output<AS2AcknowledgementConnectionSettingsArgs>) {
        this.acknowledgementConnectionSettings = value
    }

    /**
     * @param value The envelope settings.
     */
    @JvmName("xtgpvimdwcqsrkfi")
    public suspend fun envelopeSettings(`value`: Output<AS2EnvelopeSettingsArgs>) {
        this.envelopeSettings = value
    }

    /**
     * @param value The error settings.
     */
    @JvmName("tvmtdkavseomxqth")
    public suspend fun errorSettings(`value`: Output<AS2ErrorSettingsArgs>) {
        this.errorSettings = value
    }

    /**
     * @param value The MDN settings.
     */
    @JvmName("olsekajhlkiejwxw")
    public suspend fun mdnSettings(`value`: Output<AS2MdnSettingsArgs>) {
        this.mdnSettings = value
    }

    /**
     * @param value The message connection settings.
     */
    @JvmName("nffntfnxahpnkoms")
    public suspend fun messageConnectionSettings(`value`: Output<AS2MessageConnectionSettingsArgs>) {
        this.messageConnectionSettings = value
    }

    /**
     * @param value The security settings.
     */
    @JvmName("hmifexkqqbaglavj")
    public suspend fun securitySettings(`value`: Output<AS2SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value The validation settings.
     */
    @JvmName("ndrphvhnvynaxdti")
    public suspend fun validationSettings(`value`: Output<AS2ValidationSettingsArgs>) {
        this.validationSettings = value
    }

    /**
     * @param value The acknowledgement connection settings.
     */
    @JvmName("ebcsvgeajrhkjekk")
    public suspend
    fun acknowledgementConnectionSettings(`value`: AS2AcknowledgementConnectionSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementConnectionSettings = mapped
    }

    /**
     * @param argument The acknowledgement connection settings.
     */
    @JvmName("xfsjcaqyyjodnkel")
    public suspend
    fun acknowledgementConnectionSettings(argument: suspend AS2AcknowledgementConnectionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2AcknowledgementConnectionSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.acknowledgementConnectionSettings = mapped
    }

    /**
     * @param value The envelope settings.
     */
    @JvmName("ngjetjbjokutoqxs")
    public suspend fun envelopeSettings(`value`: AS2EnvelopeSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeSettings = mapped
    }

    /**
     * @param argument The envelope settings.
     */
    @JvmName("rtjnpbfvyepeeibb")
    public suspend fun envelopeSettings(argument: suspend AS2EnvelopeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2EnvelopeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envelopeSettings = mapped
    }

    /**
     * @param value The error settings.
     */
    @JvmName("hchgobbrvbnejqtk")
    public suspend fun errorSettings(`value`: AS2ErrorSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorSettings = mapped
    }

    /**
     * @param argument The error settings.
     */
    @JvmName("afrprkhseekebyqa")
    public suspend fun errorSettings(argument: suspend AS2ErrorSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2ErrorSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorSettings = mapped
    }

    /**
     * @param value The MDN settings.
     */
    @JvmName("sdefvsvhjdsbaxos")
    public suspend fun mdnSettings(`value`: AS2MdnSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mdnSettings = mapped
    }

    /**
     * @param argument The MDN settings.
     */
    @JvmName("unjgqtyhtwfahwlg")
    public suspend fun mdnSettings(argument: suspend AS2MdnSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2MdnSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mdnSettings = mapped
    }

    /**
     * @param value The message connection settings.
     */
    @JvmName("pgdyemcbsasucahi")
    public suspend fun messageConnectionSettings(`value`: AS2MessageConnectionSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageConnectionSettings = mapped
    }

    /**
     * @param argument The message connection settings.
     */
    @JvmName("udlsislxcyryjdkn")
    public suspend
    fun messageConnectionSettings(argument: suspend AS2MessageConnectionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2MessageConnectionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.messageConnectionSettings = mapped
    }

    /**
     * @param value The security settings.
     */
    @JvmName("ahckaescyahnpclt")
    public suspend fun securitySettings(`value`: AS2SecuritySettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument The security settings.
     */
    @JvmName("ddmhvymlhpwfaont")
    public suspend fun securitySettings(argument: suspend AS2SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value The validation settings.
     */
    @JvmName("rwkckqrvekbqneuc")
    public suspend fun validationSettings(`value`: AS2ValidationSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationSettings = mapped
    }

    /**
     * @param argument The validation settings.
     */
    @JvmName("joigwelpclhuumir")
    public suspend
    fun validationSettings(argument: suspend AS2ValidationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AS2ValidationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationSettings = mapped
    }

    internal fun build(): AS2ProtocolSettingsArgs = AS2ProtocolSettingsArgs(
        acknowledgementConnectionSettings = acknowledgementConnectionSettings ?: throw
            PulumiNullFieldException("acknowledgementConnectionSettings"),
        envelopeSettings = envelopeSettings ?: throw PulumiNullFieldException("envelopeSettings"),
        errorSettings = errorSettings ?: throw PulumiNullFieldException("errorSettings"),
        mdnSettings = mdnSettings ?: throw PulumiNullFieldException("mdnSettings"),
        messageConnectionSettings = messageConnectionSettings ?: throw
            PulumiNullFieldException("messageConnectionSettings"),
        securitySettings = securitySettings ?: throw PulumiNullFieldException("securitySettings"),
        validationSettings = validationSettings ?: throw PulumiNullFieldException("validationSettings"),
    )
}
