@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement security settings.
 * @property enableNRRForInboundDecodedMessages The value indicating whether to enable NRR for inbound decoded messages.
 * @property enableNRRForInboundEncodedMessages The value indicating whether to enable NRR for inbound encoded messages.
 * @property enableNRRForInboundMDN The value indicating whether to enable NRR for inbound MDN.
 * @property enableNRRForOutboundDecodedMessages The value indicating whether to enable NRR for outbound decoded messages.
 * @property enableNRRForOutboundEncodedMessages The value indicating whether to enable NRR for outbound encoded messages.
 * @property enableNRRForOutboundMDN The value indicating whether to enable NRR for outbound MDN.
 * @property encryptionCertificateName The name of the encryption certificate.
 * @property overrideGroupSigningCertificate The value indicating whether to send or request a MDN.
 * @property sha2AlgorithmFormat The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
 * @property signingCertificateName The name of the signing certificate.
 */
public data class AS2SecuritySettingsArgs(
    public val enableNRRForInboundDecodedMessages: Output<Boolean>,
    public val enableNRRForInboundEncodedMessages: Output<Boolean>,
    public val enableNRRForInboundMDN: Output<Boolean>,
    public val enableNRRForOutboundDecodedMessages: Output<Boolean>,
    public val enableNRRForOutboundEncodedMessages: Output<Boolean>,
    public val enableNRRForOutboundMDN: Output<Boolean>,
    public val encryptionCertificateName: Output<String>? = null,
    public val overrideGroupSigningCertificate: Output<Boolean>,
    public val sha2AlgorithmFormat: Output<String>? = null,
    public val signingCertificateName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs.builder()
            .enableNRRForInboundDecodedMessages(
                enableNRRForInboundDecodedMessages.applyValue({ args0 ->
                    args0
                }),
            )
            .enableNRRForInboundEncodedMessages(
                enableNRRForInboundEncodedMessages.applyValue({ args0 ->
                    args0
                }),
            )
            .enableNRRForInboundMDN(enableNRRForInboundMDN.applyValue({ args0 -> args0 }))
            .enableNRRForOutboundDecodedMessages(
                enableNRRForOutboundDecodedMessages.applyValue({ args0 ->
                    args0
                }),
            )
            .enableNRRForOutboundEncodedMessages(
                enableNRRForOutboundEncodedMessages.applyValue({ args0 ->
                    args0
                }),
            )
            .enableNRRForOutboundMDN(enableNRRForOutboundMDN.applyValue({ args0 -> args0 }))
            .encryptionCertificateName(encryptionCertificateName?.applyValue({ args0 -> args0 }))
            .overrideGroupSigningCertificate(overrideGroupSigningCertificate.applyValue({ args0 -> args0 }))
            .sha2AlgorithmFormat(sha2AlgorithmFormat?.applyValue({ args0 -> args0 }))
            .signingCertificateName(signingCertificateName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2SecuritySettingsArgs].
 */
@PulumiTagMarker
public class AS2SecuritySettingsArgsBuilder internal constructor() {
    private var enableNRRForInboundDecodedMessages: Output<Boolean>? = null

    private var enableNRRForInboundEncodedMessages: Output<Boolean>? = null

    private var enableNRRForInboundMDN: Output<Boolean>? = null

    private var enableNRRForOutboundDecodedMessages: Output<Boolean>? = null

    private var enableNRRForOutboundEncodedMessages: Output<Boolean>? = null

    private var enableNRRForOutboundMDN: Output<Boolean>? = null

    private var encryptionCertificateName: Output<String>? = null

    private var overrideGroupSigningCertificate: Output<Boolean>? = null

    private var sha2AlgorithmFormat: Output<String>? = null

    private var signingCertificateName: Output<String>? = null

    /**
     * @param value The value indicating whether to enable NRR for inbound decoded messages.
     */
    @JvmName("rowscgxylryglhgy")
    public suspend fun enableNRRForInboundDecodedMessages(`value`: Output<Boolean>) {
        this.enableNRRForInboundDecodedMessages = value
    }

    /**
     * @param value The value indicating whether to enable NRR for inbound encoded messages.
     */
    @JvmName("chqufrlhanuwxrbl")
    public suspend fun enableNRRForInboundEncodedMessages(`value`: Output<Boolean>) {
        this.enableNRRForInboundEncodedMessages = value
    }

    /**
     * @param value The value indicating whether to enable NRR for inbound MDN.
     */
    @JvmName("exxtowcponpyuqpi")
    public suspend fun enableNRRForInboundMDN(`value`: Output<Boolean>) {
        this.enableNRRForInboundMDN = value
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound decoded messages.
     */
    @JvmName("oinpwjcrfesvhhay")
    public suspend fun enableNRRForOutboundDecodedMessages(`value`: Output<Boolean>) {
        this.enableNRRForOutboundDecodedMessages = value
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound encoded messages.
     */
    @JvmName("kptnfkpxyvhwxftp")
    public suspend fun enableNRRForOutboundEncodedMessages(`value`: Output<Boolean>) {
        this.enableNRRForOutboundEncodedMessages = value
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound MDN.
     */
    @JvmName("olbfcwkusqyrxnvs")
    public suspend fun enableNRRForOutboundMDN(`value`: Output<Boolean>) {
        this.enableNRRForOutboundMDN = value
    }

    /**
     * @param value The name of the encryption certificate.
     */
    @JvmName("mfesdgitkqmcwnqr")
    public suspend fun encryptionCertificateName(`value`: Output<String>) {
        this.encryptionCertificateName = value
    }

    /**
     * @param value The value indicating whether to send or request a MDN.
     */
    @JvmName("coonkyiyggmlvjbc")
    public suspend fun overrideGroupSigningCertificate(`value`: Output<Boolean>) {
        this.overrideGroupSigningCertificate = value
    }

    /**
     * @param value The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
     */
    @JvmName("ubfeuxockfjaktbp")
    public suspend fun sha2AlgorithmFormat(`value`: Output<String>) {
        this.sha2AlgorithmFormat = value
    }

    /**
     * @param value The name of the signing certificate.
     */
    @JvmName("vnstwxvwokplgxyr")
    public suspend fun signingCertificateName(`value`: Output<String>) {
        this.signingCertificateName = value
    }

    /**
     * @param value The value indicating whether to enable NRR for inbound decoded messages.
     */
    @JvmName("tjktmcgufkdyufbv")
    public suspend fun enableNRRForInboundDecodedMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForInboundDecodedMessages = mapped
    }

    /**
     * @param value The value indicating whether to enable NRR for inbound encoded messages.
     */
    @JvmName("wnvcwfiawohyitvn")
    public suspend fun enableNRRForInboundEncodedMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForInboundEncodedMessages = mapped
    }

    /**
     * @param value The value indicating whether to enable NRR for inbound MDN.
     */
    @JvmName("eehccmvohxdldkig")
    public suspend fun enableNRRForInboundMDN(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForInboundMDN = mapped
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound decoded messages.
     */
    @JvmName("qabcfyseidmavsow")
    public suspend fun enableNRRForOutboundDecodedMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForOutboundDecodedMessages = mapped
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound encoded messages.
     */
    @JvmName("pehhejnkpumkcutn")
    public suspend fun enableNRRForOutboundEncodedMessages(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForOutboundEncodedMessages = mapped
    }

    /**
     * @param value The value indicating whether to enable NRR for outbound MDN.
     */
    @JvmName("jbdndvvdmbnrlsai")
    public suspend fun enableNRRForOutboundMDN(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableNRRForOutboundMDN = mapped
    }

    /**
     * @param value The name of the encryption certificate.
     */
    @JvmName("tkmjfthlgwxfuvqh")
    public suspend fun encryptionCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionCertificateName = mapped
    }

    /**
     * @param value The value indicating whether to send or request a MDN.
     */
    @JvmName("rqtmktbhrfqdowyp")
    public suspend fun overrideGroupSigningCertificate(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrideGroupSigningCertificate = mapped
    }

    /**
     * @param value The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
     */
    @JvmName("qbcunsowrcydwjdu")
    public suspend fun sha2AlgorithmFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sha2AlgorithmFormat = mapped
    }

    /**
     * @param value The name of the signing certificate.
     */
    @JvmName("oebmrrsabueapxue")
    public suspend fun signingCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingCertificateName = mapped
    }

    internal fun build(): AS2SecuritySettingsArgs = AS2SecuritySettingsArgs(
        enableNRRForInboundDecodedMessages = enableNRRForInboundDecodedMessages ?: throw
            PulumiNullFieldException("enableNRRForInboundDecodedMessages"),
        enableNRRForInboundEncodedMessages = enableNRRForInboundEncodedMessages ?: throw
            PulumiNullFieldException("enableNRRForInboundEncodedMessages"),
        enableNRRForInboundMDN = enableNRRForInboundMDN ?: throw
            PulumiNullFieldException("enableNRRForInboundMDN"),
        enableNRRForOutboundDecodedMessages = enableNRRForOutboundDecodedMessages ?: throw
            PulumiNullFieldException("enableNRRForOutboundDecodedMessages"),
        enableNRRForOutboundEncodedMessages = enableNRRForOutboundEncodedMessages ?: throw
            PulumiNullFieldException("enableNRRForOutboundEncodedMessages"),
        enableNRRForOutboundMDN = enableNRRForOutboundMDN ?: throw
            PulumiNullFieldException("enableNRRForOutboundMDN"),
        encryptionCertificateName = encryptionCertificateName,
        overrideGroupSigningCertificate = overrideGroupSigningCertificate ?: throw
            PulumiNullFieldException("overrideGroupSigningCertificate"),
        sha2AlgorithmFormat = sha2AlgorithmFormat,
        signingCertificateName = signingCertificateName,
    )
}
