@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactMessageIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact message identifier.
 * @property messageId The message id on which this envelope settings has to be applied.
 */
public data class EdifactMessageIdentifierArgs(
    public val messageId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactMessageIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactMessageIdentifierArgs =
        com.pulumi.azurenative.logic.inputs.EdifactMessageIdentifierArgs.builder()
            .messageId(messageId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactMessageIdentifierArgs].
 */
@PulumiTagMarker
public class EdifactMessageIdentifierArgsBuilder internal constructor() {
    private var messageId: Output<String>? = null

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("qaxnxhhtbjksqbof")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("ysxoxdjajfepsiiw")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    internal fun build(): EdifactMessageIdentifierArgs = EdifactMessageIdentifierArgs(
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
    )
}
