@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactOneWayAgreementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Edifact one way agreement.
 * @property protocolSettings The EDIFACT protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class EdifactOneWayAgreementArgs(
    public val protocolSettings: Output<EdifactProtocolSettingsArgs>,
    public val receiverBusinessIdentity: Output<BusinessIdentityArgs>,
    public val senderBusinessIdentity: Output<BusinessIdentityArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactOneWayAgreementArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactOneWayAgreementArgs =
        com.pulumi.azurenative.logic.inputs.EdifactOneWayAgreementArgs.builder()
            .protocolSettings(protocolSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .receiverBusinessIdentity(
                receiverBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .senderBusinessIdentity(
                senderBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EdifactOneWayAgreementArgs].
 */
@PulumiTagMarker
public class EdifactOneWayAgreementArgsBuilder internal constructor() {
    private var protocolSettings: Output<EdifactProtocolSettingsArgs>? = null

    private var receiverBusinessIdentity: Output<BusinessIdentityArgs>? = null

    private var senderBusinessIdentity: Output<BusinessIdentityArgs>? = null

    /**
     * @param value The EDIFACT protocol settings.
     */
    @JvmName("nvbusfbwvheijuon")
    public suspend fun protocolSettings(`value`: Output<EdifactProtocolSettingsArgs>) {
        this.protocolSettings = value
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("vlacqnlbogqoldij")
    public suspend fun receiverBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.receiverBusinessIdentity = value
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("ngkcdskeydqdgbpd")
    public suspend fun senderBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.senderBusinessIdentity = value
    }

    /**
     * @param value The EDIFACT protocol settings.
     */
    @JvmName("xpnclsdihmspsxvk")
    public suspend fun protocolSettings(`value`: EdifactProtocolSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolSettings = mapped
    }

    /**
     * @param argument The EDIFACT protocol settings.
     */
    @JvmName("gmcfslagbmayoanp")
    public suspend
    fun protocolSettings(argument: suspend EdifactProtocolSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactProtocolSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolSettings = mapped
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("bwogfquvtseutjgd")
    public suspend fun receiverBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param argument The receiver business identity
     */
    @JvmName("mejxpcvpnoubmrdl")
    public suspend
    fun receiverBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("csjumslfwvkiijus")
    public suspend fun senderBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.senderBusinessIdentity = mapped
    }

    /**
     * @param argument The sender business identity
     */
    @JvmName("sqfdvjgfdwwernxd")
    public suspend
    fun senderBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.senderBusinessIdentity = mapped
    }

    internal fun build(): EdifactOneWayAgreementArgs = EdifactOneWayAgreementArgs(
        protocolSettings = protocolSettings ?: throw PulumiNullFieldException("protocolSettings"),
        receiverBusinessIdentity = receiverBusinessIdentity ?: throw
            PulumiNullFieldException("receiverBusinessIdentity"),
        senderBusinessIdentity = senderBusinessIdentity ?: throw
            PulumiNullFieldException("senderBusinessIdentity"),
    )
}
