@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.FlowEndpointsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The flow endpoints configuration.
 * @property accessEndpointIpAddresses The access endpoint ip address.
 * @property outgoingIpAddresses The outgoing ip address.
 */
public data class FlowEndpointsArgs(
    public val accessEndpointIpAddresses: Output<List<IpAddressArgs>>? = null,
    public val outgoingIpAddresses: Output<List<IpAddressArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.FlowEndpointsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.FlowEndpointsArgs =
        com.pulumi.azurenative.logic.inputs.FlowEndpointsArgs.builder()
            .accessEndpointIpAddresses(
                accessEndpointIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outgoingIpAddresses(
                outgoingIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowEndpointsArgs].
 */
@PulumiTagMarker
public class FlowEndpointsArgsBuilder internal constructor() {
    private var accessEndpointIpAddresses: Output<List<IpAddressArgs>>? = null

    private var outgoingIpAddresses: Output<List<IpAddressArgs>>? = null

    /**
     * @param value The access endpoint ip address.
     */
    @JvmName("pgsivtlufxdcbvil")
    public suspend fun accessEndpointIpAddresses(`value`: Output<List<IpAddressArgs>>) {
        this.accessEndpointIpAddresses = value
    }

    @JvmName("hphpxgkqysbvhrrg")
    public suspend fun accessEndpointIpAddresses(vararg values: Output<IpAddressArgs>) {
        this.accessEndpointIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values The access endpoint ip address.
     */
    @JvmName("yywjcoopcuobtwrc")
    public suspend fun accessEndpointIpAddresses(values: List<Output<IpAddressArgs>>) {
        this.accessEndpointIpAddresses = Output.all(values)
    }

    /**
     * @param value The outgoing ip address.
     */
    @JvmName("ycesixixrboslrid")
    public suspend fun outgoingIpAddresses(`value`: Output<List<IpAddressArgs>>) {
        this.outgoingIpAddresses = value
    }

    @JvmName("vgsvmnyqethlrsls")
    public suspend fun outgoingIpAddresses(vararg values: Output<IpAddressArgs>) {
        this.outgoingIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values The outgoing ip address.
     */
    @JvmName("piubwqvdagokhxfw")
    public suspend fun outgoingIpAddresses(values: List<Output<IpAddressArgs>>) {
        this.outgoingIpAddresses = Output.all(values)
    }

    /**
     * @param value The access endpoint ip address.
     */
    @JvmName("ivflsigniyxqrhol")
    public suspend fun accessEndpointIpAddresses(`value`: List<IpAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessEndpointIpAddresses = mapped
    }

    /**
     * @param argument The access endpoint ip address.
     */
    @JvmName("rrocgodswsjxpyip")
    public suspend
    fun accessEndpointIpAddresses(argument: List<suspend IpAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.accessEndpointIpAddresses = mapped
    }

    /**
     * @param argument The access endpoint ip address.
     */
    @JvmName("mvlaxnjdbenffgjb")
    public suspend fun accessEndpointIpAddresses(
        vararg
        argument: suspend IpAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { IpAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.accessEndpointIpAddresses = mapped
    }

    /**
     * @param argument The access endpoint ip address.
     */
    @JvmName("cljpccaowoosaksf")
    public suspend fun accessEndpointIpAddresses(argument: suspend IpAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessEndpointIpAddresses = mapped
    }

    /**
     * @param values The access endpoint ip address.
     */
    @JvmName("pflyffgijlygfndd")
    public suspend fun accessEndpointIpAddresses(vararg values: IpAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessEndpointIpAddresses = mapped
    }

    /**
     * @param value The outgoing ip address.
     */
    @JvmName("qynboitqueamgmav")
    public suspend fun outgoingIpAddresses(`value`: List<IpAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outgoingIpAddresses = mapped
    }

    /**
     * @param argument The outgoing ip address.
     */
    @JvmName("dvvlqyxqtieeelys")
    public suspend fun outgoingIpAddresses(argument: List<suspend IpAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outgoingIpAddresses = mapped
    }

    /**
     * @param argument The outgoing ip address.
     */
    @JvmName("agdxaasjvwrfnylq")
    public suspend fun outgoingIpAddresses(vararg argument: suspend IpAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outgoingIpAddresses = mapped
    }

    /**
     * @param argument The outgoing ip address.
     */
    @JvmName("lysyympusxpwvnwt")
    public suspend fun outgoingIpAddresses(argument: suspend IpAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outgoingIpAddresses = mapped
    }

    /**
     * @param values The outgoing ip address.
     */
    @JvmName("qjeunfmddlopokeb")
    public suspend fun outgoingIpAddresses(vararg values: IpAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outgoingIpAddresses = mapped
    }

    internal fun build(): FlowEndpointsArgs = FlowEndpointsArgs(
        accessEndpointIpAddresses = accessEndpointIpAddresses,
        outgoingIpAddresses = outgoingIpAddresses,
    )
}
