@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSessionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 * @property sessionName The integration account session name.
 */
public data class GetIntegrationAccountSessionPlainArgs(
    public val integrationAccountName: String,
    public val resourceGroupName: String,
    public val sessionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSessionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSessionPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSessionPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sessionName(sessionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountSessionPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountSessionPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var sessionName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("nbfjxivfbfafucgr")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("uypjapcejpsjycus")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account session name.
     */
    @JvmName("inxnenbaoipfeosy")
    public suspend fun sessionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sessionName = mapped
    }

    internal fun build(): GetIntegrationAccountSessionPlainArgs =
        GetIntegrationAccountSessionPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sessionName = sessionName ?: throw PulumiNullFieldException("sessionName"),
        )
}
