@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationAccountMapPropertiesParametersSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters schema of integration account map.
 * @property ref The reference name.
 */
public data class IntegrationAccountMapPropertiesParametersSchemaArgs(
    public val ref: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationAccountMapPropertiesParametersSchemaArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.IntegrationAccountMapPropertiesParametersSchemaArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationAccountMapPropertiesParametersSchemaArgs.builder()
            .ref(ref?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationAccountMapPropertiesParametersSchemaArgs].
 */
@PulumiTagMarker
public class IntegrationAccountMapPropertiesParametersSchemaArgsBuilder internal constructor() {
    private var ref: Output<String>? = null

    /**
     * @param value The reference name.
     */
    @JvmName("amkrponeurjysyok")
    public suspend fun ref(`value`: Output<String>) {
        this.ref = value
    }

    /**
     * @param value The reference name.
     */
    @JvmName("tskspwdwwenhgyup")
    public suspend fun ref(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ref = mapped
    }

    internal fun build(): IntegrationAccountMapPropertiesParametersSchemaArgs =
        IntegrationAccountMapPropertiesParametersSchemaArgs(
            ref = ref,
        )
}
