@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.KeyVaultKeyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The reference to the key vault key.
 * @property keyName The private key name in key vault.
 * @property keyVault The key vault reference.
 * @property keyVersion The private key version in key vault.
 */
public data class KeyVaultKeyReferenceArgs(
    public val keyName: Output<String>,
    public val keyVault: Output<KeyVaultKeyReferenceKeyVaultArgs>,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.KeyVaultKeyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.KeyVaultKeyReferenceArgs =
        com.pulumi.azurenative.logic.inputs.KeyVaultKeyReferenceArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVault(keyVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultKeyReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyReferenceArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVault: Output<KeyVaultKeyReferenceKeyVaultArgs>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The private key name in key vault.
     */
    @JvmName("spktujwohxupledm")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The key vault reference.
     */
    @JvmName("aibrqygkywgmlgwl")
    public suspend fun keyVault(`value`: Output<KeyVaultKeyReferenceKeyVaultArgs>) {
        this.keyVault = value
    }

    /**
     * @param value The private key version in key vault.
     */
    @JvmName("oobccbybjlfgxvyr")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The private key name in key vault.
     */
    @JvmName("womqgihigvvsjrem")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The key vault reference.
     */
    @JvmName("qaikndldmudvtbuw")
    public suspend fun keyVault(`value`: KeyVaultKeyReferenceKeyVaultArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument The key vault reference.
     */
    @JvmName("gxoajxlonyqsykut")
    public suspend
    fun keyVault(argument: suspend KeyVaultKeyReferenceKeyVaultArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceKeyVaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value The private key version in key vault.
     */
    @JvmName("qemcbyrwsjviogsy")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultKeyReferenceArgs = KeyVaultKeyReferenceArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVault = keyVault ?: throw PulumiNullFieldException("keyVault"),
        keyVersion = keyVersion,
    )
}
