@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 * @property triggerName The workflow trigger name.
 * @property versionId The workflow versionId.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowVersionTriggerCallbackUrlPlainArgs(
    public val keyType: Either<String, KeyType>? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
    public val triggerName: String,
    public val versionId: String,
    public val workflowName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgs.builder()
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 }))
            .versionId(versionId.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowVersionTriggerCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowVersionTriggerCallbackUrlPlainArgsBuilder internal constructor() {
    private var keyType: Either<String, KeyType>? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    private var versionId: String? = null

    private var workflowName: String? = null

    /**
     * @param value The key type.
     */
    @JvmName("onddpdhasclqlrsm")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("yotbfjmanboanjvx")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("dngjvrrchhpkbjiw")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("wnmlwqdimvperfml")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("oursjjskbtantpkw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow trigger name.
     */
    @JvmName("wbfobvxeasmhtpql")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    /**
     * @param value The workflow versionId.
     */
    @JvmName("bflpjieqvvrcvwgc")
    public suspend fun versionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionId = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("ttqbdlkwgnamnwlv")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowVersionTriggerCallbackUrlPlainArgs =
        ListWorkflowVersionTriggerCallbackUrlPlainArgs(
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
            versionId = versionId ?: throw PulumiNullFieldException("versionId"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
