@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.PartnerContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account partner content.
 * @property b2b The B2B partner content.
 */
public data class PartnerContentArgs(
    public val b2b: Output<B2BPartnerContentArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.PartnerContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.PartnerContentArgs =
        com.pulumi.azurenative.logic.inputs.PartnerContentArgs.builder()
            .b2b(b2b?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PartnerContentArgs].
 */
@PulumiTagMarker
public class PartnerContentArgsBuilder internal constructor() {
    private var b2b: Output<B2BPartnerContentArgs>? = null

    /**
     * @param value The B2B partner content.
     */
    @JvmName("dthbercfdkewqdbk")
    public suspend fun b2b(`value`: Output<B2BPartnerContentArgs>) {
        this.b2b = value
    }

    /**
     * @param value The B2B partner content.
     */
    @JvmName("gmcuwfdxovkmipqc")
    public suspend fun b2b(`value`: B2BPartnerContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.b2b = mapped
    }

    /**
     * @param argument The B2B partner content.
     */
    @JvmName("hlxgfpqoqyenagst")
    public suspend fun b2b(argument: suspend B2BPartnerContentArgsBuilder.() -> Unit) {
        val toBeMapped = B2BPartnerContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.b2b = mapped
    }

    internal fun build(): PartnerContentArgs = PartnerContentArgs(
        b2b = b2b,
    )
}
