@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12EnvelopeSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.UsageIndicator
import com.pulumi.azurenative.logic.kotlin.enums.X12DateFormat
import com.pulumi.azurenative.logic.kotlin.enums.X12TimeFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 agreement envelope settings.
 * @property controlStandardsId The controls standards id.
 * @property controlVersionNumber The control version number.
 * @property enableDefaultGroupHeaders The value indicating whether to enable default group headers.
 * @property functionalGroupId The functional group id.
 * @property groupControlNumberLowerBound The group control number lower bound.
 * @property groupControlNumberUpperBound The group control number upper bound.
 * @property groupHeaderAgencyCode The group header agency code.
 * @property groupHeaderDateFormat The group header date format.
 * @property groupHeaderTimeFormat The group header time format.
 * @property groupHeaderVersion The group header version.
 * @property interchangeControlNumberLowerBound The interchange  control number lower bound.
 * @property interchangeControlNumberUpperBound The interchange  control number upper bound.
 * @property overwriteExistingTransactionSetControlNumber The value indicating whether to overwrite existing transaction set control number.
 * @property receiverApplicationId The receiver application id.
 * @property rolloverGroupControlNumber The value indicating whether to rollover group control number.
 * @property rolloverInterchangeControlNumber The value indicating whether to rollover interchange control number.
 * @property rolloverTransactionSetControlNumber The value indicating whether to rollover transaction set control number.
 * @property senderApplicationId The sender application id.
 * @property transactionSetControlNumberLowerBound The transaction set control number lower bound.
 * @property transactionSetControlNumberPrefix The transaction set control number prefix.
 * @property transactionSetControlNumberSuffix The transaction set control number suffix.
 * @property transactionSetControlNumberUpperBound The transaction set control number upper bound.
 * @property usageIndicator The usage indicator.
 * @property useControlStandardsIdAsRepetitionCharacter The value indicating whether to use control standards id as repetition character.
 */
public data class X12EnvelopeSettingsArgs(
    public val controlStandardsId: Output<Int>,
    public val controlVersionNumber: Output<String>,
    public val enableDefaultGroupHeaders: Output<Boolean>,
    public val functionalGroupId: Output<String>? = null,
    public val groupControlNumberLowerBound: Output<Int>,
    public val groupControlNumberUpperBound: Output<Int>,
    public val groupHeaderAgencyCode: Output<String>,
    public val groupHeaderDateFormat: Output<Either<String, X12DateFormat>>,
    public val groupHeaderTimeFormat: Output<Either<String, X12TimeFormat>>,
    public val groupHeaderVersion: Output<String>,
    public val interchangeControlNumberLowerBound: Output<Int>,
    public val interchangeControlNumberUpperBound: Output<Int>,
    public val overwriteExistingTransactionSetControlNumber: Output<Boolean>,
    public val receiverApplicationId: Output<String>,
    public val rolloverGroupControlNumber: Output<Boolean>,
    public val rolloverInterchangeControlNumber: Output<Boolean>,
    public val rolloverTransactionSetControlNumber: Output<Boolean>,
    public val senderApplicationId: Output<String>,
    public val transactionSetControlNumberLowerBound: Output<Int>,
    public val transactionSetControlNumberPrefix: Output<String>? = null,
    public val transactionSetControlNumberSuffix: Output<String>? = null,
    public val transactionSetControlNumberUpperBound: Output<Int>,
    public val usageIndicator: Output<Either<String, UsageIndicator>>,
    public val useControlStandardsIdAsRepetitionCharacter: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12EnvelopeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12EnvelopeSettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12EnvelopeSettingsArgs.builder()
            .controlStandardsId(controlStandardsId.applyValue({ args0 -> args0 }))
            .controlVersionNumber(controlVersionNumber.applyValue({ args0 -> args0 }))
            .enableDefaultGroupHeaders(enableDefaultGroupHeaders.applyValue({ args0 -> args0 }))
            .functionalGroupId(functionalGroupId?.applyValue({ args0 -> args0 }))
            .groupControlNumberLowerBound(groupControlNumberLowerBound.applyValue({ args0 -> args0 }))
            .groupControlNumberUpperBound(groupControlNumberUpperBound.applyValue({ args0 -> args0 }))
            .groupHeaderAgencyCode(groupHeaderAgencyCode.applyValue({ args0 -> args0 }))
            .groupHeaderDateFormat(
                groupHeaderDateFormat.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .groupHeaderTimeFormat(
                groupHeaderTimeFormat.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .groupHeaderVersion(groupHeaderVersion.applyValue({ args0 -> args0 }))
            .interchangeControlNumberLowerBound(
                interchangeControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .interchangeControlNumberUpperBound(
                interchangeControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            )
            .overwriteExistingTransactionSetControlNumber(
                overwriteExistingTransactionSetControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .receiverApplicationId(receiverApplicationId.applyValue({ args0 -> args0 }))
            .rolloverGroupControlNumber(rolloverGroupControlNumber.applyValue({ args0 -> args0 }))
            .rolloverInterchangeControlNumber(rolloverInterchangeControlNumber.applyValue({ args0 -> args0 }))
            .rolloverTransactionSetControlNumber(
                rolloverTransactionSetControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .senderApplicationId(senderApplicationId.applyValue({ args0 -> args0 }))
            .transactionSetControlNumberLowerBound(
                transactionSetControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberPrefix(
                transactionSetControlNumberPrefix?.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberSuffix(
                transactionSetControlNumberSuffix?.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberUpperBound(
                transactionSetControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            )
            .usageIndicator(
                usageIndicator.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .useControlStandardsIdAsRepetitionCharacter(
                useControlStandardsIdAsRepetitionCharacter.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [X12EnvelopeSettingsArgs].
 */
@PulumiTagMarker
public class X12EnvelopeSettingsArgsBuilder internal constructor() {
    private var controlStandardsId: Output<Int>? = null

    private var controlVersionNumber: Output<String>? = null

    private var enableDefaultGroupHeaders: Output<Boolean>? = null

    private var functionalGroupId: Output<String>? = null

    private var groupControlNumberLowerBound: Output<Int>? = null

    private var groupControlNumberUpperBound: Output<Int>? = null

    private var groupHeaderAgencyCode: Output<String>? = null

    private var groupHeaderDateFormat: Output<Either<String, X12DateFormat>>? = null

    private var groupHeaderTimeFormat: Output<Either<String, X12TimeFormat>>? = null

    private var groupHeaderVersion: Output<String>? = null

    private var interchangeControlNumberLowerBound: Output<Int>? = null

    private var interchangeControlNumberUpperBound: Output<Int>? = null

    private var overwriteExistingTransactionSetControlNumber: Output<Boolean>? = null

    private var receiverApplicationId: Output<String>? = null

    private var rolloverGroupControlNumber: Output<Boolean>? = null

    private var rolloverInterchangeControlNumber: Output<Boolean>? = null

    private var rolloverTransactionSetControlNumber: Output<Boolean>? = null

    private var senderApplicationId: Output<String>? = null

    private var transactionSetControlNumberLowerBound: Output<Int>? = null

    private var transactionSetControlNumberPrefix: Output<String>? = null

    private var transactionSetControlNumberSuffix: Output<String>? = null

    private var transactionSetControlNumberUpperBound: Output<Int>? = null

    private var usageIndicator: Output<Either<String, UsageIndicator>>? = null

    private var useControlStandardsIdAsRepetitionCharacter: Output<Boolean>? = null

    /**
     * @param value The controls standards id.
     */
    @JvmName("upmagahbluonnijo")
    public suspend fun controlStandardsId(`value`: Output<Int>) {
        this.controlStandardsId = value
    }

    /**
     * @param value The control version number.
     */
    @JvmName("clcpkwhksjvdbqcn")
    public suspend fun controlVersionNumber(`value`: Output<String>) {
        this.controlVersionNumber = value
    }

    /**
     * @param value The value indicating whether to enable default group headers.
     */
    @JvmName("sviermvjqiangsbx")
    public suspend fun enableDefaultGroupHeaders(`value`: Output<Boolean>) {
        this.enableDefaultGroupHeaders = value
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("xsfqjmrrpbkdtmhr")
    public suspend fun functionalGroupId(`value`: Output<String>) {
        this.functionalGroupId = value
    }

    /**
     * @param value The group control number lower bound.
     */
    @JvmName("pkcvyfdiugdjlulf")
    public suspend fun groupControlNumberLowerBound(`value`: Output<Int>) {
        this.groupControlNumberLowerBound = value
    }

    /**
     * @param value The group control number upper bound.
     */
    @JvmName("igkvxttjtawwolft")
    public suspend fun groupControlNumberUpperBound(`value`: Output<Int>) {
        this.groupControlNumberUpperBound = value
    }

    /**
     * @param value The group header agency code.
     */
    @JvmName("lcruouggfwbflbfg")
    public suspend fun groupHeaderAgencyCode(`value`: Output<String>) {
        this.groupHeaderAgencyCode = value
    }

    /**
     * @param value The group header date format.
     */
    @JvmName("sqhqbpmcsaxdxrto")
    public suspend fun groupHeaderDateFormat(`value`: Output<Either<String, X12DateFormat>>) {
        this.groupHeaderDateFormat = value
    }

    /**
     * @param value The group header time format.
     */
    @JvmName("fxsrnsruhdoxsyjd")
    public suspend fun groupHeaderTimeFormat(`value`: Output<Either<String, X12TimeFormat>>) {
        this.groupHeaderTimeFormat = value
    }

    /**
     * @param value The group header version.
     */
    @JvmName("jlaxjqrdyrtiyvri")
    public suspend fun groupHeaderVersion(`value`: Output<String>) {
        this.groupHeaderVersion = value
    }

    /**
     * @param value The interchange  control number lower bound.
     */
    @JvmName("jkywprihewqbthmf")
    public suspend fun interchangeControlNumberLowerBound(`value`: Output<Int>) {
        this.interchangeControlNumberLowerBound = value
    }

    /**
     * @param value The interchange  control number upper bound.
     */
    @JvmName("argvqukvaswcwqfj")
    public suspend fun interchangeControlNumberUpperBound(`value`: Output<Int>) {
        this.interchangeControlNumberUpperBound = value
    }

    /**
     * @param value The value indicating whether to overwrite existing transaction set control number.
     */
    @JvmName("grdmbnhdtnvgyjie")
    public suspend fun overwriteExistingTransactionSetControlNumber(`value`: Output<Boolean>) {
        this.overwriteExistingTransactionSetControlNumber = value
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("sfcisqnljjunbloo")
    public suspend fun receiverApplicationId(`value`: Output<String>) {
        this.receiverApplicationId = value
    }

    /**
     * @param value The value indicating whether to rollover group control number.
     */
    @JvmName("yrxnplbehjksptee")
    public suspend fun rolloverGroupControlNumber(`value`: Output<Boolean>) {
        this.rolloverGroupControlNumber = value
    }

    /**
     * @param value The value indicating whether to rollover interchange control number.
     */
    @JvmName("ptprdjylmwduevcy")
    public suspend fun rolloverInterchangeControlNumber(`value`: Output<Boolean>) {
        this.rolloverInterchangeControlNumber = value
    }

    /**
     * @param value The value indicating whether to rollover transaction set control number.
     */
    @JvmName("bkourxmsqtlubgvd")
    public suspend fun rolloverTransactionSetControlNumber(`value`: Output<Boolean>) {
        this.rolloverTransactionSetControlNumber = value
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("lyecdbaktsabgseo")
    public suspend fun senderApplicationId(`value`: Output<String>) {
        this.senderApplicationId = value
    }

    /**
     * @param value The transaction set control number lower bound.
     */
    @JvmName("kdruureucomkdbtl")
    public suspend fun transactionSetControlNumberLowerBound(`value`: Output<Int>) {
        this.transactionSetControlNumberLowerBound = value
    }

    /**
     * @param value The transaction set control number prefix.
     */
    @JvmName("fxqeknckwubtxutg")
    public suspend fun transactionSetControlNumberPrefix(`value`: Output<String>) {
        this.transactionSetControlNumberPrefix = value
    }

    /**
     * @param value The transaction set control number suffix.
     */
    @JvmName("fekdyjpxkmoidhlk")
    public suspend fun transactionSetControlNumberSuffix(`value`: Output<String>) {
        this.transactionSetControlNumberSuffix = value
    }

    /**
     * @param value The transaction set control number upper bound.
     */
    @JvmName("wgmkrwvjduvlshwf")
    public suspend fun transactionSetControlNumberUpperBound(`value`: Output<Int>) {
        this.transactionSetControlNumberUpperBound = value
    }

    /**
     * @param value The usage indicator.
     */
    @JvmName("tnjpwguussatfakn")
    public suspend fun usageIndicator(`value`: Output<Either<String, UsageIndicator>>) {
        this.usageIndicator = value
    }

    /**
     * @param value The value indicating whether to use control standards id as repetition character.
     */
    @JvmName("dwlpxtnvfahxwjcn")
    public suspend fun useControlStandardsIdAsRepetitionCharacter(`value`: Output<Boolean>) {
        this.useControlStandardsIdAsRepetitionCharacter = value
    }

    /**
     * @param value The controls standards id.
     */
    @JvmName("ssblihvlbjcdrhfw")
    public suspend fun controlStandardsId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlStandardsId = mapped
    }

    /**
     * @param value The control version number.
     */
    @JvmName("yetlxfxuhygefqyb")
    public suspend fun controlVersionNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlVersionNumber = mapped
    }

    /**
     * @param value The value indicating whether to enable default group headers.
     */
    @JvmName("bdniqtgetrnncejg")
    public suspend fun enableDefaultGroupHeaders(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDefaultGroupHeaders = mapped
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("snpvpondlewdnlgc")
    public suspend fun functionalGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionalGroupId = mapped
    }

    /**
     * @param value The group control number lower bound.
     */
    @JvmName("oomxdhtamnndjidl")
    public suspend fun groupControlNumberLowerBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupControlNumberLowerBound = mapped
    }

    /**
     * @param value The group control number upper bound.
     */
    @JvmName("wfcwyxyvscqyqpfp")
    public suspend fun groupControlNumberUpperBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupControlNumberUpperBound = mapped
    }

    /**
     * @param value The group header agency code.
     */
    @JvmName("twdeffsqauxooeag")
    public suspend fun groupHeaderAgencyCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderAgencyCode = mapped
    }

    /**
     * @param value The group header date format.
     */
    @JvmName("rwtuisoyerbshuaf")
    public suspend fun groupHeaderDateFormat(`value`: Either<String, X12DateFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderDateFormat = mapped
    }

    /**
     * @param value The group header date format.
     */
    @JvmName("yafyhvinqhnrjjnx")
    public fun groupHeaderDateFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, X12DateFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderDateFormat = mapped
    }

    /**
     * @param value The group header date format.
     */
    @JvmName("mcyouylxwaxtlqia")
    public fun groupHeaderDateFormat(`value`: X12DateFormat) {
        val toBeMapped = Either.ofRight<String, X12DateFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderDateFormat = mapped
    }

    /**
     * @param value The group header time format.
     */
    @JvmName("xrbsceudvnurvanv")
    public suspend fun groupHeaderTimeFormat(`value`: Either<String, X12TimeFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderTimeFormat = mapped
    }

    /**
     * @param value The group header time format.
     */
    @JvmName("wlkqjmxfwiwmwaxq")
    public fun groupHeaderTimeFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, X12TimeFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderTimeFormat = mapped
    }

    /**
     * @param value The group header time format.
     */
    @JvmName("myndoeyhfqpnbxax")
    public fun groupHeaderTimeFormat(`value`: X12TimeFormat) {
        val toBeMapped = Either.ofRight<String, X12TimeFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderTimeFormat = mapped
    }

    /**
     * @param value The group header version.
     */
    @JvmName("tjbdfwrhwcslwdvh")
    public suspend fun groupHeaderVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupHeaderVersion = mapped
    }

    /**
     * @param value The interchange  control number lower bound.
     */
    @JvmName("qoseglpblxppmxdy")
    public suspend fun interchangeControlNumberLowerBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeControlNumberLowerBound = mapped
    }

    /**
     * @param value The interchange  control number upper bound.
     */
    @JvmName("kvfgkskurascvqna")
    public suspend fun interchangeControlNumberUpperBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeControlNumberUpperBound = mapped
    }

    /**
     * @param value The value indicating whether to overwrite existing transaction set control number.
     */
    @JvmName("ejmjujjelafbrkxl")
    public suspend fun overwriteExistingTransactionSetControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overwriteExistingTransactionSetControlNumber = mapped
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("gywofbloluqxpqih")
    public suspend fun receiverApplicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiverApplicationId = mapped
    }

    /**
     * @param value The value indicating whether to rollover group control number.
     */
    @JvmName("fclrjmmacmylkbvj")
    public suspend fun rolloverGroupControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverGroupControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to rollover interchange control number.
     */
    @JvmName("xtrysmtoxvtqlngk")
    public suspend fun rolloverInterchangeControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverInterchangeControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to rollover transaction set control number.
     */
    @JvmName("evfnnjtmxtesdove")
    public suspend fun rolloverTransactionSetControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverTransactionSetControlNumber = mapped
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("mrqvwyrlwaurwcvo")
    public suspend fun senderApplicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.senderApplicationId = mapped
    }

    /**
     * @param value The transaction set control number lower bound.
     */
    @JvmName("lnigyoonxnoqqmgb")
    public suspend fun transactionSetControlNumberLowerBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transactionSetControlNumberLowerBound = mapped
    }

    /**
     * @param value The transaction set control number prefix.
     */
    @JvmName("fqmdbnfupjehjmul")
    public suspend fun transactionSetControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transactionSetControlNumberPrefix = mapped
    }

    /**
     * @param value The transaction set control number suffix.
     */
    @JvmName("dojxveikrkdjccsy")
    public suspend fun transactionSetControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transactionSetControlNumberSuffix = mapped
    }

    /**
     * @param value The transaction set control number upper bound.
     */
    @JvmName("ensqodwocorpjnko")
    public suspend fun transactionSetControlNumberUpperBound(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transactionSetControlNumberUpperBound = mapped
    }

    /**
     * @param value The usage indicator.
     */
    @JvmName("txfecwjpsyssmgac")
    public suspend fun usageIndicator(`value`: Either<String, UsageIndicator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageIndicator = mapped
    }

    /**
     * @param value The usage indicator.
     */
    @JvmName("luxsiuvnmgrvenig")
    public fun usageIndicator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsageIndicator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageIndicator = mapped
    }

    /**
     * @param value The usage indicator.
     */
    @JvmName("wqeesmqbisoytawq")
    public fun usageIndicator(`value`: UsageIndicator) {
        val toBeMapped = Either.ofRight<String, UsageIndicator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageIndicator = mapped
    }

    /**
     * @param value The value indicating whether to use control standards id as repetition character.
     */
    @JvmName("nredvwslopsiwxam")
    public suspend fun useControlStandardsIdAsRepetitionCharacter(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useControlStandardsIdAsRepetitionCharacter = mapped
    }

    internal fun build(): X12EnvelopeSettingsArgs = X12EnvelopeSettingsArgs(
        controlStandardsId = controlStandardsId ?: throw PulumiNullFieldException("controlStandardsId"),
        controlVersionNumber = controlVersionNumber ?: throw
            PulumiNullFieldException("controlVersionNumber"),
        enableDefaultGroupHeaders = enableDefaultGroupHeaders ?: throw
            PulumiNullFieldException("enableDefaultGroupHeaders"),
        functionalGroupId = functionalGroupId,
        groupControlNumberLowerBound = groupControlNumberLowerBound ?: throw
            PulumiNullFieldException("groupControlNumberLowerBound"),
        groupControlNumberUpperBound = groupControlNumberUpperBound ?: throw
            PulumiNullFieldException("groupControlNumberUpperBound"),
        groupHeaderAgencyCode = groupHeaderAgencyCode ?: throw
            PulumiNullFieldException("groupHeaderAgencyCode"),
        groupHeaderDateFormat = groupHeaderDateFormat ?: throw
            PulumiNullFieldException("groupHeaderDateFormat"),
        groupHeaderTimeFormat = groupHeaderTimeFormat ?: throw
            PulumiNullFieldException("groupHeaderTimeFormat"),
        groupHeaderVersion = groupHeaderVersion ?: throw PulumiNullFieldException("groupHeaderVersion"),
        interchangeControlNumberLowerBound = interchangeControlNumberLowerBound ?: throw
            PulumiNullFieldException("interchangeControlNumberLowerBound"),
        interchangeControlNumberUpperBound = interchangeControlNumberUpperBound ?: throw
            PulumiNullFieldException("interchangeControlNumberUpperBound"),
        overwriteExistingTransactionSetControlNumber = overwriteExistingTransactionSetControlNumber ?: throw
            PulumiNullFieldException("overwriteExistingTransactionSetControlNumber"),
        receiverApplicationId = receiverApplicationId ?: throw
            PulumiNullFieldException("receiverApplicationId"),
        rolloverGroupControlNumber = rolloverGroupControlNumber ?: throw
            PulumiNullFieldException("rolloverGroupControlNumber"),
        rolloverInterchangeControlNumber = rolloverInterchangeControlNumber ?: throw
            PulumiNullFieldException("rolloverInterchangeControlNumber"),
        rolloverTransactionSetControlNumber = rolloverTransactionSetControlNumber ?: throw
            PulumiNullFieldException("rolloverTransactionSetControlNumber"),
        senderApplicationId = senderApplicationId ?: throw PulumiNullFieldException("senderApplicationId"),
        transactionSetControlNumberLowerBound = transactionSetControlNumberLowerBound ?: throw
            PulumiNullFieldException("transactionSetControlNumberLowerBound"),
        transactionSetControlNumberPrefix = transactionSetControlNumberPrefix,
        transactionSetControlNumberSuffix = transactionSetControlNumberSuffix,
        transactionSetControlNumberUpperBound = transactionSetControlNumberUpperBound ?: throw
            PulumiNullFieldException("transactionSetControlNumberUpperBound"),
        usageIndicator = usageIndicator ?: throw PulumiNullFieldException("usageIndicator"),
        useControlStandardsIdAsRepetitionCharacter = useControlStandardsIdAsRepetitionCharacter ?: throw
            PulumiNullFieldException("useControlStandardsIdAsRepetitionCharacter"),
    )
}
