@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12MessageIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 message identifier.
 * @property messageId The message id.
 */
public data class X12MessageIdentifierArgs(
    public val messageId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12MessageIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12MessageIdentifierArgs =
        com.pulumi.azurenative.logic.inputs.X12MessageIdentifierArgs.builder()
            .messageId(messageId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12MessageIdentifierArgs].
 */
@PulumiTagMarker
public class X12MessageIdentifierArgsBuilder internal constructor() {
    private var messageId: Output<String>? = null

    /**
     * @param value The message id.
     */
    @JvmName("jgmlmvkvlubdneio")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The message id.
     */
    @JvmName("kmphuigwypwbjodc")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    internal fun build(): X12MessageIdentifierArgs = X12MessageIdentifierArgs(
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
    )
}
