@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12SchemaReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 schema reference.
 * @property messageId The message id.
 * @property schemaName The schema name.
 * @property schemaVersion The schema version.
 * @property senderApplicationId The sender application id.
 */
public data class X12SchemaReferenceArgs(
    public val messageId: Output<String>,
    public val schemaName: Output<String>,
    public val schemaVersion: Output<String>,
    public val senderApplicationId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12SchemaReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12SchemaReferenceArgs =
        com.pulumi.azurenative.logic.inputs.X12SchemaReferenceArgs.builder()
            .messageId(messageId.applyValue({ args0 -> args0 }))
            .schemaName(schemaName.applyValue({ args0 -> args0 }))
            .schemaVersion(schemaVersion.applyValue({ args0 -> args0 }))
            .senderApplicationId(senderApplicationId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12SchemaReferenceArgs].
 */
@PulumiTagMarker
public class X12SchemaReferenceArgsBuilder internal constructor() {
    private var messageId: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var schemaVersion: Output<String>? = null

    private var senderApplicationId: Output<String>? = null

    /**
     * @param value The message id.
     */
    @JvmName("kvftoxrybbuoksxa")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The schema name.
     */
    @JvmName("xholikdkiyuiobdt")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The schema version.
     */
    @JvmName("rhphmphyocpakcnc")
    public suspend fun schemaVersion(`value`: Output<String>) {
        this.schemaVersion = value
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("jqxqtiqjijacfghd")
    public suspend fun senderApplicationId(`value`: Output<String>) {
        this.senderApplicationId = value
    }

    /**
     * @param value The message id.
     */
    @JvmName("uhplbhavsltfqkjt")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The schema name.
     */
    @JvmName("cjnrwdjbpgmaqlew")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The schema version.
     */
    @JvmName("ofwjhmkgjhkmyafv")
    public suspend fun schemaVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaVersion = mapped
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("dhdfrqwbyofgavbh")
    public suspend fun senderApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderApplicationId = mapped
    }

    internal fun build(): X12SchemaReferenceArgs = X12SchemaReferenceArgs(
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
        schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
        schemaVersion = schemaVersion ?: throw PulumiNullFieldException("schemaVersion"),
        senderApplicationId = senderApplicationId,
    )
}
