@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The AS2 agreement envelope settings.
 * @property autogenerateFileName The value indicating whether to auto generate file name.
 * @property fileNameTemplate The template for file name.
 * @property messageContentType The message content type.
 * @property suspendMessageOnFileNameGenerationError The value indicating whether to suspend message on file name generation error.
 * @property transmitFileNameInMimeHeader The value indicating whether to transmit file name in mime header.
 */
public data class AS2EnvelopeSettingsResponse(
    public val autogenerateFileName: Boolean,
    public val fileNameTemplate: String,
    public val messageContentType: String,
    public val suspendMessageOnFileNameGenerationError: Boolean,
    public val transmitFileNameInMimeHeader: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2EnvelopeSettingsResponse):
            AS2EnvelopeSettingsResponse = AS2EnvelopeSettingsResponse(
            autogenerateFileName = javaType.autogenerateFileName(),
            fileNameTemplate = javaType.fileNameTemplate(),
            messageContentType = javaType.messageContentType(),
            suspendMessageOnFileNameGenerationError = javaType.suspendMessageOnFileNameGenerationError(),
            transmitFileNameInMimeHeader = javaType.transmitFileNameInMimeHeader(),
        )
    }
}
