@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The assembly properties definition.
 * @property assemblyCulture The assembly culture.
 * @property assemblyName The assembly name.
 * @property assemblyPublicKeyToken The assembly public key token.
 * @property assemblyVersion The assembly version.
 * @property changedTime The artifact changed time.
 * @property content
 * @property contentLink The content link.
 * @property contentType The content type.
 * @property createdTime The artifact creation time.
 * @property metadata
 */
public data class AssemblyPropertiesResponse(
    public val assemblyCulture: String? = null,
    public val assemblyName: String,
    public val assemblyPublicKeyToken: String? = null,
    public val assemblyVersion: String? = null,
    public val changedTime: String? = null,
    public val content: Any? = null,
    public val contentLink: ContentLinkResponse? = null,
    public val contentType: String? = null,
    public val createdTime: String? = null,
    public val metadata: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AssemblyPropertiesResponse):
            AssemblyPropertiesResponse = AssemblyPropertiesResponse(
            assemblyCulture = javaType.assemblyCulture().map({ args0 -> args0 }).orElse(null),
            assemblyName = javaType.assemblyName(),
            assemblyPublicKeyToken = javaType.assemblyPublicKeyToken().map({ args0 -> args0 }).orElse(null),
            assemblyVersion = javaType.assemblyVersion().map({ args0 -> args0 }).orElse(null),
            changedTime = javaType.changedTime().map({ args0 -> args0 }).orElse(null),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            contentLink = javaType.contentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
        )
    }
}
