@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The azure resource error info.
 * @property code The error code.
 * @property details The error details.
 * @property message The error message.
 */
public data class AzureResourceErrorInfoResponse(
    public val code: String,
    public val details: List<AzureResourceErrorInfoResponse>? = null,
    public val message: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AzureResourceErrorInfoResponse):
            AzureResourceErrorInfoResponse = AzureResourceErrorInfoResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.AzureResourceErrorInfoResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
        )
    }
}
