@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The batch release criteria.
 * @property batchSize The batch size in bytes.
 * @property messageCount The message count.
 * @property recurrence The recurrence.
 */
public data class BatchReleaseCriteriaResponse(
    public val batchSize: Int? = null,
    public val messageCount: Int? = null,
    public val recurrence: WorkflowTriggerRecurrenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.BatchReleaseCriteriaResponse):
            BatchReleaseCriteriaResponse = BatchReleaseCriteriaResponse(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            messageCount = javaType.messageCount().map({ args0 -> args0 }).orElse(null),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.WorkflowTriggerRecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
