@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Edifact envelope override settings.
 * @property applicationPassword The application password.
 * @property associationAssignedCode The association assigned code.
 * @property controllingAgencyCode The controlling agency code.
 * @property functionalGroupId The functional group id.
 * @property groupHeaderMessageRelease The group header message release.
 * @property groupHeaderMessageVersion The group header message version.
 * @property messageAssociationAssignedCode The message association assigned code.
 * @property messageId The message id on which this envelope settings has to be applied.
 * @property messageRelease The message release version on which this envelope settings has to be applied.
 * @property messageVersion The message version on which this envelope settings has to be applied.
 * @property receiverApplicationId The receiver application id.
 * @property receiverApplicationQualifier The receiver application qualifier.
 * @property senderApplicationId The sender application id.
 * @property senderApplicationQualifier The sender application qualifier.
 * @property targetNamespace The target namespace on which this envelope settings has to be applied.
 */
public data class EdifactEnvelopeOverrideResponse(
    public val applicationPassword: String? = null,
    public val associationAssignedCode: String? = null,
    public val controllingAgencyCode: String? = null,
    public val functionalGroupId: String? = null,
    public val groupHeaderMessageRelease: String? = null,
    public val groupHeaderMessageVersion: String? = null,
    public val messageAssociationAssignedCode: String? = null,
    public val messageId: String? = null,
    public val messageRelease: String? = null,
    public val messageVersion: String? = null,
    public val receiverApplicationId: String? = null,
    public val receiverApplicationQualifier: String? = null,
    public val senderApplicationId: String? = null,
    public val senderApplicationQualifier: String? = null,
    public val targetNamespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactEnvelopeOverrideResponse):
            EdifactEnvelopeOverrideResponse = EdifactEnvelopeOverrideResponse(
            applicationPassword = javaType.applicationPassword().map({ args0 -> args0 }).orElse(null),
            associationAssignedCode = javaType.associationAssignedCode().map({ args0 -> args0 }).orElse(null),
            controllingAgencyCode = javaType.controllingAgencyCode().map({ args0 -> args0 }).orElse(null),
            functionalGroupId = javaType.functionalGroupId().map({ args0 -> args0 }).orElse(null),
            groupHeaderMessageRelease = javaType.groupHeaderMessageRelease().map({ args0 ->
                args0
            }).orElse(null),
            groupHeaderMessageVersion = javaType.groupHeaderMessageVersion().map({ args0 ->
                args0
            }).orElse(null),
            messageAssociationAssignedCode = javaType.messageAssociationAssignedCode().map({ args0 ->
                args0
            }).orElse(null),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            messageRelease = javaType.messageRelease().map({ args0 -> args0 }).orElse(null),
            messageVersion = javaType.messageVersion().map({ args0 -> args0 }).orElse(null),
            receiverApplicationId = javaType.receiverApplicationId().map({ args0 -> args0 }).orElse(null),
            receiverApplicationQualifier = javaType.receiverApplicationQualifier().map({ args0 ->
                args0
            }).orElse(null),
            senderApplicationId = javaType.senderApplicationId().map({ args0 -> args0 }).orElse(null),
            senderApplicationQualifier = javaType.senderApplicationQualifier().map({ args0 ->
                args0
            }).orElse(null),
            targetNamespace = javaType.targetNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
