@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact validation override settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property enforceCharacterSet The value indicating whether to validate character Set.
 * @property messageId The message id on which the validation settings has to be applied.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateEDITypes The value indicating whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to validate XSD types.
 */
public data class EdifactValidationOverrideResponse(
    public val allowLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val enforceCharacterSet: Boolean,
    public val messageId: String,
    public val trailingSeparatorPolicy: String,
    public val trimLeadingAndTrailingSpacesAndZeroes: Boolean,
    public val validateEDITypes: Boolean,
    public val validateXSDTypes: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactValidationOverrideResponse):
            EdifactValidationOverrideResponse = EdifactValidationOverrideResponse(
            allowLeadingAndTrailingSpacesAndZeroes = javaType.allowLeadingAndTrailingSpacesAndZeroes(),
            enforceCharacterSet = javaType.enforceCharacterSet(),
            messageId = javaType.messageId(),
            trailingSeparatorPolicy = javaType.trailingSeparatorPolicy(),
            trimLeadingAndTrailingSpacesAndZeroes = javaType.trimLeadingAndTrailingSpacesAndZeroes(),
            validateEDITypes = javaType.validateEDITypes(),
            validateXSDTypes = javaType.validateXSDTypes(),
        )
    }
}
