@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The integration service environment managed api.
 * @property apiDefinitionUrl The API definition.
 * @property apiDefinitions The api definitions.
 * @property backendService The backend service.
 * @property capabilities The capabilities.
 * @property category The category.
 * @property connectionParameters The connection parameters.
 * @property deploymentParameters The integration service environment managed api deployment parameters.
 * @property generalInformation The api general information.
 * @property id The resource id.
 * @property integrationServiceEnvironment The integration service environment reference.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property policies The policies for the API.
 * @property provisioningState The provisioning state.
 * @property runtimeUrls The runtime urls.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationServiceEnvironmentManagedApiResult(
    public val apiDefinitionUrl: String,
    public val apiDefinitions: ApiResourceDefinitionsResponse,
    public val backendService: ApiResourceBackendServiceResponse,
    public val capabilities: List<String>,
    public val category: String,
    public val connectionParameters: Map<String, Any>,
    public val deploymentParameters:
    IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse? = null,
    public val generalInformation: ApiResourceGeneralInformationResponse,
    public val id: String,
    public val integrationServiceEnvironment: ResourceReferenceResponse? = null,
    public val location: String? = null,
    public val metadata: ApiResourceMetadataResponse,
    public val name: String,
    public val policies: ApiResourcePoliciesResponse,
    public val provisioningState: String,
    public val runtimeUrls: List<String>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationServiceEnvironmentManagedApiResult):
            GetIntegrationServiceEnvironmentManagedApiResult =
            GetIntegrationServiceEnvironmentManagedApiResult(
                apiDefinitionUrl = javaType.apiDefinitionUrl(),
                apiDefinitions = javaType.apiDefinitions().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceDefinitionsResponse.Companion.toKotlin(args0)
                }),
                backendService = javaType.backendService().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceBackendServiceResponse.Companion.toKotlin(args0)
                }),
                capabilities = javaType.capabilities().map({ args0 -> args0 }),
                category = javaType.category(),
                connectionParameters = javaType.connectionParameters().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                deploymentParameters = javaType.deploymentParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                generalInformation = javaType.generalInformation().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceGeneralInformationResponse.Companion.toKotlin(args0)
                }),
                id = javaType.id(),
                integrationServiceEnvironment = javaType.integrationServiceEnvironment().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                metadata = javaType.metadata().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceMetadataResponse.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
                policies = javaType.policies().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiResourcePoliciesResponse.Companion.toKotlin(args0)
                }),
                provisioningState = javaType.provisioningState(),
                runtimeUrls = javaType.runtimeUrls().map({ args0 -> args0 }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
