@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The integration service environment properties.
 * @property encryptionConfiguration The encryption configuration.
 * @property endpointsConfiguration The endpoints configuration.
 * @property integrationServiceEnvironmentId Gets the tracking id.
 * @property networkConfiguration The network configuration.
 * @property provisioningState The provisioning state.
 * @property state The integration service environment state.
 */
public data class IntegrationServiceEnvironmentPropertiesResponse(
    public val encryptionConfiguration: IntegrationServiceEnvironmenEncryptionConfigurationResponse? =
        null,
    public val endpointsConfiguration: FlowEndpointsConfigurationResponse? = null,
    public val integrationServiceEnvironmentId: String? = null,
    public val networkConfiguration: NetworkConfigurationResponse? = null,
    public val provisioningState: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.IntegrationServiceEnvironmentPropertiesResponse):
            IntegrationServiceEnvironmentPropertiesResponse =
            IntegrationServiceEnvironmentPropertiesResponse(
                encryptionConfiguration = javaType.encryptionConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmenEncryptionConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                endpointsConfiguration = javaType.endpointsConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                integrationServiceEnvironmentId = javaType.integrationServiceEnvironmentId().map({ args0 ->
                    args0
                }).orElse(null),
                networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
            )
    }
}
