@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The integration account RosettaNet ProcessConfiguration Acknowledgement settings.
 * @property isNonRepudiationRequired The non-repudiation is required or not.
 * @property timeToAcknowledgeInSeconds The time to acknowledge in seconds.
 */
public data class RosettaNetPipAcknowledgmentOfReceiptSettingsResponse(
    public val isNonRepudiationRequired: Boolean,
    public val timeToAcknowledgeInSeconds: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.RosettaNetPipAcknowledgmentOfReceiptSettingsResponse):
            RosettaNetPipAcknowledgmentOfReceiptSettingsResponse =
            RosettaNetPipAcknowledgmentOfReceiptSettingsResponse(
                isNonRepudiationRequired = javaType.isNonRepudiationRequired(),
                timeToAcknowledgeInSeconds = javaType.timeToAcknowledgeInSeconds(),
            )
    }
}
