@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The integration account RosettaNet ProcessConfiguration activity behavior.
 * @property actionType The value indicating whether the RosettaNet PIP is used for a single action.
 * @property isAuthorizationRequired The value indicating whether authorization is required.
 * @property isSecuredTransportRequired The value indicating whether secured transport is required.
 * @property nonRepudiationOfOriginAndContent The value indicating whether non-repudiation is for origin and content.
 * @property persistentConfidentialityScope The persistent confidentiality encryption scope.
 * @property responseType The value indicating whether the RosettaNet PIP communication is synchronous.
 * @property retryCount The value indicating retry count.
 * @property timeToPerformInSeconds The time to perform in seconds.
 */
public data class RosettaNetPipActivityBehaviorResponse(
    public val actionType: String,
    public val isAuthorizationRequired: Boolean,
    public val isSecuredTransportRequired: Boolean,
    public val nonRepudiationOfOriginAndContent: Boolean,
    public val persistentConfidentialityScope: String,
    public val responseType: String,
    public val retryCount: Int,
    public val timeToPerformInSeconds: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.RosettaNetPipActivityBehaviorResponse):
            RosettaNetPipActivityBehaviorResponse = RosettaNetPipActivityBehaviorResponse(
            actionType = javaType.actionType(),
            isAuthorizationRequired = javaType.isAuthorizationRequired(),
            isSecuredTransportRequired = javaType.isSecuredTransportRequired(),
            nonRepudiationOfOriginAndContent = javaType.nonRepudiationOfOriginAndContent(),
            persistentConfidentialityScope = javaType.persistentConfidentialityScope(),
            responseType = javaType.responseType(),
            retryCount = javaType.retryCount(),
            timeToPerformInSeconds = javaType.timeToPerformInSeconds(),
        )
    }
}
