@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The X12 agreement content.
 * @property receiveAgreement The X12 one-way receive agreement.
 * @property sendAgreement The X12 one-way send agreement.
 */
public data class X12AgreementContentResponse(
    public val receiveAgreement: X12OneWayAgreementResponse,
    public val sendAgreement: X12OneWayAgreementResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12AgreementContentResponse):
            X12AgreementContentResponse = X12AgreementContentResponse(
            receiveAgreement = javaType.receiveAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12OneWayAgreementResponse.Companion.toKotlin(args0)
            }),
            sendAgreement = javaType.sendAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.X12OneWayAgreementResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
