@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The X12 envelope override settings.
 * @property dateFormat The date format.
 * @property functionalIdentifierCode The functional identifier code.
 * @property headerVersion The header version.
 * @property messageId The message id on which this envelope settings has to be applied.
 * @property protocolVersion The protocol version on which this envelope settings has to be applied.
 * @property receiverApplicationId The receiver application id.
 * @property responsibleAgencyCode The responsible agency code.
 * @property senderApplicationId The sender application id.
 * @property targetNamespace The target namespace on which this envelope settings has to be applied.
 * @property timeFormat The time format.
 */
public data class X12EnvelopeOverrideResponse(
    public val dateFormat: String,
    public val functionalIdentifierCode: String? = null,
    public val headerVersion: String,
    public val messageId: String,
    public val protocolVersion: String,
    public val receiverApplicationId: String,
    public val responsibleAgencyCode: String,
    public val senderApplicationId: String,
    public val targetNamespace: String,
    public val timeFormat: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12EnvelopeOverrideResponse):
            X12EnvelopeOverrideResponse = X12EnvelopeOverrideResponse(
            dateFormat = javaType.dateFormat(),
            functionalIdentifierCode = javaType.functionalIdentifierCode().map({ args0 -> args0 }).orElse(null),
            headerVersion = javaType.headerVersion(),
            messageId = javaType.messageId(),
            protocolVersion = javaType.protocolVersion(),
            receiverApplicationId = javaType.receiverApplicationId(),
            responsibleAgencyCode = javaType.responsibleAgencyCode(),
            senderApplicationId = javaType.senderApplicationId(),
            targetNamespace = javaType.targetNamespace(),
            timeFormat = javaType.timeFormat(),
        )
    }
}
