@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The X12 agreement framing settings.
 * @property characterSet The X12 character set.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property replaceCharacter The replacement character.
 * @property replaceSeparatorsInPayload The value indicating whether to replace separators in payload.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 */
public data class X12FramingSettingsResponse(
    public val characterSet: String,
    public val componentSeparator: Int,
    public val dataElementSeparator: Int,
    public val replaceCharacter: Int,
    public val replaceSeparatorsInPayload: Boolean,
    public val segmentTerminator: Int,
    public val segmentTerminatorSuffix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12FramingSettingsResponse):
            X12FramingSettingsResponse = X12FramingSettingsResponse(
            characterSet = javaType.characterSet(),
            componentSeparator = javaType.componentSeparator(),
            dataElementSeparator = javaType.dataElementSeparator(),
            replaceCharacter = javaType.replaceCharacter(),
            replaceSeparatorsInPayload = javaType.replaceSeparatorsInPayload(),
            segmentTerminator = javaType.segmentTerminator(),
            segmentTerminatorSuffix = javaType.segmentTerminatorSuffix(),
        )
    }
}
