@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.MonitorArgs.builder
import com.pulumi.azurenative.logz.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.MonitorPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.MonitorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### Monitors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Logz.Monitor("monitor", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewMonitor(ctx, "monitor", &logz.MonitorArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.Monitor;
 * import com.pulumi.azurenative.logz.MonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:Monitor myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}
 * ```
 * @property identity
 * @property location
 * @property monitorName Monitor resource name
 * @property properties Properties specific to the monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags
 */
public data class MonitorArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.MonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.MonitorArgs =
        com.pulumi.azurenative.logz.MonitorArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitorArgs].
 */
@PulumiTagMarker
public class MonitorArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<MonitorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("bkbkjipqsikbjqdy")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value
     */
    @JvmName("hieeoarnrniurbdi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("yfjtdvuopplpvhhl")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("khhefiiawqtjnqoe")
    public suspend fun properties(`value`: Output<MonitorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ioknkvtiaqbcmccw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("srgpcaruwdknfvrw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("gsjkdeupjlaprhrn")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qxclbbfdrggoruld")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value
     */
    @JvmName("vyfsjaogfihhcqqa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("umhsnhurjijydwrm")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("bohiuopwcqafmwnh")
    public suspend fun properties(`value`: MonitorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties specific to the monitor resource.
     */
    @JvmName("cahykrjvhswubtbl")
    public suspend fun properties(argument: suspend MonitorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xkflyrcyjcnnbcfv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("yuwfujekjfpdavcu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("shbiqdrlvamtwkmf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitorArgs = MonitorArgs(
        identity = identity,
        location = location,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
