@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.SubAccountArgs.builder
import com.pulumi.azurenative.logz.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.MonitorPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.MonitorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### subAccount_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subAccount = new AzureNative.Logz.SubAccount("subAccount", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         SubAccountName = "SubAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewSubAccount(ctx, "subAccount", &logz.SubAccountArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SubAccountName:    pulumi.String("SubAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.SubAccount;
 * import com.pulumi.azurenative.logz.SubAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subAccount = new SubAccount("subAccount", SubAccountArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .subAccountName("SubAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:SubAccount myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}
 * ```
 * @property identity
 * @property location
 * @property monitorName Monitor resource name
 * @property properties Properties specific to the monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subAccountName Sub Account resource name
 * @property tags
 */
public data class SubAccountArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subAccountName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.SubAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.SubAccountArgs =
        com.pulumi.azurenative.logz.SubAccountArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subAccountName(subAccountName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubAccountArgs].
 */
@PulumiTagMarker
public class SubAccountArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<MonitorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subAccountName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("xjnueoewtjtfbdww")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value
     */
    @JvmName("hifcgqqmnwjjxagw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("youaeejmpqeohgdt")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("bwfpyeptqqirvybc")
    public suspend fun properties(`value`: Output<MonitorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dkkvpvlvtboysekn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("nudlwsbmmudwgqwk")
    public suspend fun subAccountName(`value`: Output<String>) {
        this.subAccountName = value
    }

    /**
     * @param value
     */
    @JvmName("tkohxtyhpyveqdug")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ikubloanqtxwkfmr")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ilqpqopikrklfwqd")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value
     */
    @JvmName("govpmtwthxsonwdn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("vytqsbcyafmhbigj")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("bjlhuskalynkqvsl")
    public suspend fun properties(`value`: MonitorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties specific to the monitor resource.
     */
    @JvmName("ccajbjgprpcatshp")
    public suspend fun properties(argument: suspend MonitorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mmnxpdkhcgbahoqw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("puwrphlgnyrweruv")
    public suspend fun subAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subAccountName = mapped
    }

    /**
     * @param value
     */
    @JvmName("luvwipflypjwnivh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("pjbfrdgvbflnbpjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubAccountArgs = SubAccountArgs(
        identity = identity,
        location = location,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subAccountName = subAccountName,
        tags = tags,
    )
}
