@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.GetTagRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleSetName
 */
public data class GetTagRulePlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
    public val ruleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.GetTagRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.GetTagRulePlainArgs =
        com.pulumi.azurenative.logz.inputs.GetTagRulePlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleSetName(ruleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagRulePlainArgs].
 */
@PulumiTagMarker
public class GetTagRulePlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    private var ruleSetName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("chbhavjaidlfhriu")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dtdkapfypvpnweaw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjkxrcshygwywowg")
    public suspend fun ruleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleSetName = mapped
    }

    internal fun build(): GetTagRulePlainArgs = GetTagRulePlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleSetName = ruleSetName ?: throw PulumiNullFieldException("ruleSetName"),
    )
}
