@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.ListMonitorUserRolesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property emailAddress Email of the user used by Logz for contacting them if needed
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMonitorUserRolesPlainArgs(
    public val emailAddress: String? = null,
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.ListMonitorUserRolesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.ListMonitorUserRolesPlainArgs =
        com.pulumi.azurenative.logz.inputs.ListMonitorUserRolesPlainArgs.builder()
            .emailAddress(emailAddress?.let({ args0 -> args0 }))
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMonitorUserRolesPlainArgs].
 */
@PulumiTagMarker
public class ListMonitorUserRolesPlainArgsBuilder internal constructor() {
    private var emailAddress: String? = null

    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Email of the user used by Logz for contacting them if needed
     */
    @JvmName("slyeahwqcqyfllfl")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.emailAddress = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("ijfslxcweftqllbh")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dudvysuevkgoejhv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMonitorUserRolesPlainArgs = ListMonitorUserRolesPlainArgs(
        emailAddress = emailAddress,
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
