@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.MetricRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of rules for sending metrics for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 * @property subscriptionId Subscription Id for which filtering tags are applicable
 */
public data class MetricRulesArgs(
    public val filteringTags: Output<List<FilteringTagArgs>>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.MetricRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.MetricRulesArgs =
        com.pulumi.azurenative.logz.inputs.MetricRulesArgs.builder()
            .filteringTags(
                filteringTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricRulesArgs].
 */
@PulumiTagMarker
public class MetricRulesArgsBuilder internal constructor() {
    private var filteringTags: Output<List<FilteringTagArgs>>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("qtosrqatnnisxmoa")
    public suspend fun filteringTags(`value`: Output<List<FilteringTagArgs>>) {
        this.filteringTags = value
    }

    @JvmName("lwbynwkbpfbeyejk")
    public suspend fun filteringTags(vararg values: Output<FilteringTagArgs>) {
        this.filteringTags = Output.all(values.asList())
    }

    /**
     * @param values List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("qrooodgsglmjnpon")
    public suspend fun filteringTags(values: List<Output<FilteringTagArgs>>) {
        this.filteringTags = Output.all(values)
    }

    /**
     * @param value Subscription Id for which filtering tags are applicable
     */
    @JvmName("goiogsbwhefdlhue")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("slcolhnyhdiujguk")
    public suspend fun filteringTags(`value`: List<FilteringTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("jkwxrljyoifipwrx")
    public suspend fun filteringTags(argument: List<suspend FilteringTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("mafaymantrsmpsua")
    public suspend fun filteringTags(vararg argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("iwadbipmvelkgtbr")
    public suspend fun filteringTags(argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilteringTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param values List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("xqdjitcctnidowvl")
    public suspend fun filteringTags(vararg values: FilteringTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param value Subscription Id for which filtering tags are applicable
     */
    @JvmName("dxqtgfjofmatqqte")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): MetricRulesArgs = MetricRulesArgs(
        filteringTags = filteringTags,
        subscriptionId = subscriptionId,
    )
}
