@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.MonitoringTagRulesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the properties for a TagRules resource.
 * @property logRules Set of rules for sending logs for the Monitor resource.
 */
public data class MonitoringTagRulesPropertiesArgs(
    public val logRules: Output<LogRulesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.MonitoringTagRulesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.MonitoringTagRulesPropertiesArgs =
        com.pulumi.azurenative.logz.inputs.MonitoringTagRulesPropertiesArgs.builder()
            .logRules(logRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MonitoringTagRulesPropertiesArgs].
 */
@PulumiTagMarker
public class MonitoringTagRulesPropertiesArgsBuilder internal constructor() {
    private var logRules: Output<LogRulesArgs>? = null

    /**
     * @param value Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("fuvqoyvdfejwmpri")
    public suspend fun logRules(`value`: Output<LogRulesArgs>) {
        this.logRules = value
    }

    /**
     * @param value Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("ndmqnuskfiyolbch")
    public suspend fun logRules(`value`: LogRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logRules = mapped
    }

    /**
     * @param argument Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("iwwkgcaudkfgmtfp")
    public suspend fun logRules(argument: suspend LogRulesArgsBuilder.() -> Unit) {
        val toBeMapped = LogRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logRules = mapped
    }

    internal fun build(): MonitoringTagRulesPropertiesArgs = MonitoringTagRulesPropertiesArgs(
        logRules = logRules,
    )
}
