@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.PlanDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingCycle different billing cycles like MONTHLY/WEEKLY. this could be enum
 * @property effectiveDate date when plan was applied
 * @property planDetails plan id as published by Logz
 * @property usageType different usage type like PAYG/COMMITTED. this could be enum
 */
public data class PlanDataArgs(
    public val billingCycle: Output<String>? = null,
    public val effectiveDate: Output<String>? = null,
    public val planDetails: Output<String>? = null,
    public val usageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.PlanDataArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.PlanDataArgs =
        com.pulumi.azurenative.logz.inputs.PlanDataArgs.builder()
            .billingCycle(billingCycle?.applyValue({ args0 -> args0 }))
            .effectiveDate(effectiveDate?.applyValue({ args0 -> args0 }))
            .planDetails(planDetails?.applyValue({ args0 -> args0 }))
            .usageType(usageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanDataArgs].
 */
@PulumiTagMarker
public class PlanDataArgsBuilder internal constructor() {
    private var billingCycle: Output<String>? = null

    private var effectiveDate: Output<String>? = null

    private var planDetails: Output<String>? = null

    private var usageType: Output<String>? = null

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY. this could be enum
     */
    @JvmName("nnxxnaogrwdxtivh")
    public suspend fun billingCycle(`value`: Output<String>) {
        this.billingCycle = value
    }

    /**
     * @param value date when plan was applied
     */
    @JvmName("bsowcvcnxoyllwip")
    public suspend fun effectiveDate(`value`: Output<String>) {
        this.effectiveDate = value
    }

    /**
     * @param value plan id as published by Logz
     */
    @JvmName("haodneblemrugogt")
    public suspend fun planDetails(`value`: Output<String>) {
        this.planDetails = value
    }

    /**
     * @param value different usage type like PAYG/COMMITTED. this could be enum
     */
    @JvmName("hyxxunidxhcetocw")
    public suspend fun usageType(`value`: Output<String>) {
        this.usageType = value
    }

    /**
     * @param value different billing cycles like MONTHLY/WEEKLY. this could be enum
     */
    @JvmName("vbykpndkmvucwxyo")
    public suspend fun billingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingCycle = mapped
    }

    /**
     * @param value date when plan was applied
     */
    @JvmName("wlmcagriwtauscge")
    public suspend fun effectiveDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveDate = mapped
    }

    /**
     * @param value plan id as published by Logz
     */
    @JvmName("gykexwqychcuiiib")
    public suspend fun planDetails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planDetails = mapped
    }

    /**
     * @param value different usage type like PAYG/COMMITTED. this could be enum
     */
    @JvmName("gbxbkxcwvjqeumqi")
    public suspend fun usageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    internal fun build(): PlanDataArgs = PlanDataArgs(
        billingCycle = billingCycle,
        effectiveDate = effectiveDate,
        planDetails = planDetails,
        usageType = usageType,
    )
}
