@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property companyName Name of the Logz organization.
 * @property enterpriseAppId The Id of the Enterprise App used for Single sign on.
 * @property id Id of the Logz organization.
 * @property singleSignOnUrl The login URL specific to this Logz Organization.
 */
public data class LogzOrganizationPropertiesResponse(
    public val companyName: String? = null,
    public val enterpriseAppId: String? = null,
    public val id: String,
    public val singleSignOnUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.LogzOrganizationPropertiesResponse):
            LogzOrganizationPropertiesResponse = LogzOrganizationPropertiesResponse(
            companyName = javaType.companyName().map({ args0 -> args0 }).orElse(null),
            enterpriseAppId = javaType.enterpriseAppId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            singleSignOnUrl = javaType.singleSignOnUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
