@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the properties for a TagRules resource.
 * @property logRules Set of rules for sending logs for the Monitor resource.
 * @property provisioningState Flag specifying if the resource provisioning state as tracked by ARM.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 */
public data class MonitoringTagRulesPropertiesResponse(
    public val logRules: LogRulesResponse? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.MonitoringTagRulesPropertiesResponse):
            MonitoringTagRulesPropertiesResponse = MonitoringTagRulesPropertiesResponse(
            logRules = javaType.logRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.LogRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
