@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin

import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs.builder
import com.pulumi.azurenative.m365securityandcompliance.kotlin.enums.Kind
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.ServicesPropertiesArgs
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.ServicesPropertiesArgsBuilder
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.ServicesResourceIdentityArgs
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.ServicesResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the service.
 * Azure REST API version: 2021-03-25-preview. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * ## Example Usage
 * ### Create or Update a service with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForO365ManagementActivityAPI = new AzureNative.M365SecurityAndCompliance.PrivateLinkServicesForO365ManagementActivityAPI("privateLinkServicesForO365ManagementActivityAPI", new()
 *     {
 *         Identity = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Kind = AzureNative.M365SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.M365SecurityAndCompliance.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = "Disabled",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateLinkServicesForO365ManagementActivityAPI(ctx, "privateLinkServicesForO365ManagementActivityAPI", &m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs{
 * 			Identity: &m365securityandcompliance.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Kind:     m365securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: m365securityandcompliance.ServicesPropertiesResponse{
 * 				AccessPolicies: m365securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &m365securityandcompliance.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &m365securityandcompliance.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Float64(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &m365securityandcompliance.ServiceCosmosDbConfigurationInfoArgs{
 * 					KeyVaultKeyUri:  pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput: pulumi.Float64(1000),
 * 				},
 * 				ExportConfiguration: &m365securityandcompliance.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: m365securityandcompliance.PrivateEndpointConnectionArray{},
 * 				PublicNetworkAccess:        pulumi.String("Disabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPI;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForO365ManagementActivityAPI = new PrivateLinkServicesForO365ManagementActivityAPI("privateLinkServicesForO365ManagementActivityAPI", PrivateLinkServicesForO365ManagementActivityAPIArgs.builder()
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("accessPolicies",
 *                     Map.of("objectId", "c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 *                     Map.of("objectId", "5b307da8-43d4-492b-8b66-b0294ade872f")),
 *                 Map.entry("authenticationConfiguration", Map.ofEntries(
 *                     Map.entry("audience", "https://azurehealthcareapis.com"),
 *                     Map.entry("authority", "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 *                     Map.entry("smartProxyEnabled", true)
 *                 )),
 *                 Map.entry("corsConfiguration", Map.ofEntries(
 *                     Map.entry("allowCredentials", false),
 *                     Map.entry("headers", "*"),
 *                     Map.entry("maxAge", 1440),
 *                     Map.entry("methods",
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT"),
 *                     Map.entry("origins", "*")
 *                 )),
 *                 Map.entry("cosmosDbConfiguration", Map.ofEntries(
 *                     Map.entry("keyVaultKeyUri", "https://my-vault.vault.azure.net/keys/my-key"),
 *                     Map.entry("offerThroughput", 1000)
 *                 )),
 *                 Map.entry("exportConfiguration", Map.of("storageAccountName", "existingStorageAccount")),
 *                 Map.entry("privateEndpointConnections", ),
 *                 Map.entry("publicNetworkAccess", "Disabled")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicesForO365ManagementActivityAPI = new AzureNative.M365SecurityAndCompliance.PrivateLinkServicesForO365ManagementActivityAPI("privateLinkServicesForO365ManagementActivityAPI", new()
 *     {
 *         Kind = AzureNative.M365SecurityAndCompliance.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.M365SecurityAndCompliance.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.M365SecurityAndCompliance.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service2",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateLinkServicesForO365ManagementActivityAPI(ctx, "privateLinkServicesForO365ManagementActivityAPI", &m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs{
 * 			Kind:     m365securityandcompliance.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: m365securityandcompliance.ServicesPropertiesResponse{
 * 				AccessPolicies: m365securityandcompliance.ServiceAccessPolicyEntryArray{
 * 					&m365securityandcompliance.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service2"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPI;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicesForO365ManagementActivityAPI = new PrivateLinkServicesForO365ManagementActivityAPI("privateLinkServicesForO365ManagementActivityAPI", PrivateLinkServicesForO365ManagementActivityAPIArgs.builder()
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(Map.of("accessPolicies", Map.of("objectId", "c487e7d1-3210-41a3-8ccc-e9372b78da47")))
 *             .resourceGroupName("rg1")
 *             .resourceName("service2")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:m365securityandcompliance:PrivateLinkServicesForO365ManagementActivityAPI service2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/{resourceName}
 * ```
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property properties The common properties of a service.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 * @property tags The resource tags.
 */
public data class PrivateLinkServicesForO365ManagementActivityAPIArgs(
    public val identity: Output<ServicesResourceIdentityArgs>? = null,
    public val kind: Output<Kind>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ServicesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs> {
    override fun toJava():
        com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs =
        com.pulumi.azurenative.m365securityandcompliance.PrivateLinkServicesForO365ManagementActivityAPIArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServicesForO365ManagementActivityAPIArgs].
 */
@PulumiTagMarker
public class PrivateLinkServicesForO365ManagementActivityAPIArgsBuilder internal constructor() {
    private var identity: Output<ServicesResourceIdentityArgs>? = null

    private var kind: Output<Kind>? = null

    private var location: Output<String>? = null

    private var properties: Output<ServicesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("bwvpticbqkbotock")
    public suspend fun identity(`value`: Output<ServicesResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("dqafivjweedcgpqh")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("lsjkemmghayicwmv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("shvujedknrfcdbkf")
    public suspend fun properties(`value`: Output<ServicesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("qmefdoyeuyhqfnpw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("mvtiogdioulakqrk")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("citdbknxdywbnryt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("ssobokshcgttkwsa")
    public suspend fun identity(`value`: ServicesResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("vfuoeekeqecqlgcl")
    public suspend fun identity(argument: suspend ServicesResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("ifllpvsyjxxenjro")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ckblrvmxktlqgrxn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("psatvsuuamakwdpr")
    public suspend fun properties(`value`: ServicesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The common properties of a service.
     */
    @JvmName("crndjtrmfmgmxmxn")
    public suspend fun properties(argument: suspend ServicesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("rdqfevlvflyxhgbn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("gxskejwjamxnpnjv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ldtaeeoqssfjftdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("yvpslchpfegnsxdr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkServicesForO365ManagementActivityAPIArgs =
        PrivateLinkServicesForO365ManagementActivityAPIArgs(
            identity = identity,
            kind = kind,
            location = location,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            tags = tags,
        )
}
