@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.MachineLearningWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the machine learning workspace containing the experiment that is source for the web service.
 * @property id Specifies the workspace ID of the machine learning workspace associated with the web service
 */
public data class MachineLearningWorkspaceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.MachineLearningWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.MachineLearningWorkspaceArgs =
        com.pulumi.azurenative.machinelearning.inputs.MachineLearningWorkspaceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineLearningWorkspaceArgs].
 */
@PulumiTagMarker
public class MachineLearningWorkspaceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Specifies the workspace ID of the machine learning workspace associated with the web service
     */
    @JvmName("pppgcrwgyusowuxd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies the workspace ID of the machine learning workspace associated with the web service
     */
    @JvmName("pjfyqbacgacfggkd")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): MachineLearningWorkspaceArgs = MachineLearningWorkspaceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
