@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Nested parameter definition.
 * @property interfaceString The interface string name for the nested parameter.
 * @property parameters The definition of the parameter.
 */
public data class ModeValueInfoArgs(
    public val interfaceString: Output<String>? = null,
    public val parameters: Output<List<ModuleAssetParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs =
        com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs.builder()
            .interfaceString(interfaceString?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ModeValueInfoArgs].
 */
@PulumiTagMarker
public class ModeValueInfoArgsBuilder internal constructor() {
    private var interfaceString: Output<String>? = null

    private var parameters: Output<List<ModuleAssetParameterArgs>>? = null

    /**
     * @param value The interface string name for the nested parameter.
     */
    @JvmName("jnxqixtyxjwkocci")
    public suspend fun interfaceString(`value`: Output<String>) {
        this.interfaceString = value
    }

    /**
     * @param value The definition of the parameter.
     */
    @JvmName("uqcnnvcsbqaoahxt")
    public suspend fun parameters(`value`: Output<List<ModuleAssetParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("tfpxntyilwrjhmun")
    public suspend fun parameters(vararg values: Output<ModuleAssetParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The definition of the parameter.
     */
    @JvmName("chiyqlsventurjuo")
    public suspend fun parameters(values: List<Output<ModuleAssetParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The interface string name for the nested parameter.
     */
    @JvmName("ysmeekggmtkuclrl")
    public suspend fun interfaceString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceString = mapped
    }

    /**
     * @param value The definition of the parameter.
     */
    @JvmName("vrxgqwnkdxqrjops")
    public suspend fun parameters(`value`: List<ModuleAssetParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("naqeucktctsyyijj")
    public suspend
    fun parameters(argument: List<suspend ModuleAssetParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("nlngybbjhcobkyvm")
    public suspend fun parameters(
        vararg
        argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("lhnxmmpuvldhlldu")
    public suspend fun parameters(argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModuleAssetParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The definition of the parameter.
     */
    @JvmName("gkvycihpfctqqguq")
    public suspend fun parameters(vararg values: ModuleAssetParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ModeValueInfoArgs = ModeValueInfoArgs(
        interfaceString = interfaceString,
        parameters = parameters,
    )
}
