@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.TableSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The swagger 2.0 schema describing a single service input or output. See Swagger specification: http://swagger.io/specification/
 * @property description Swagger schema description.
 * @property format The format, if 'type' is not 'object'
 * @property properties The set of columns within the data table.
 * @property title Swagger schema title.
 * @property type The type of the entity described in swagger.
 */
public data class TableSpecificationArgs(
    public val description: Output<String>? = null,
    public val format: Output<String>? = null,
    public val properties: Output<Map<String, ColumnSpecificationArgs>>? = null,
    public val title: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.TableSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.TableSpecificationArgs =
        com.pulumi.azurenative.machinelearning.inputs.TableSpecificationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSpecificationArgs].
 */
@PulumiTagMarker
public class TableSpecificationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var format: Output<String>? = null

    private var properties: Output<Map<String, ColumnSpecificationArgs>>? = null

    private var title: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Swagger schema description.
     */
    @JvmName("oheyhgxicaqgnomo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The format, if 'type' is not 'object'
     */
    @JvmName("bjdtqrlopsqsnnuh")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The set of columns within the data table.
     */
    @JvmName("knmwskijytpavcru")
    public suspend fun properties(`value`: Output<Map<String, ColumnSpecificationArgs>>) {
        this.properties = value
    }

    /**
     * @param value Swagger schema title.
     */
    @JvmName("rseolofusjpcmogw")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The type of the entity described in swagger.
     */
    @JvmName("cofxjkcohsqnpppd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Swagger schema description.
     */
    @JvmName("mvsoosegpxgrwqpu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The format, if 'type' is not 'object'
     */
    @JvmName("gdobjlpnfovuqngw")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The set of columns within the data table.
     */
    @JvmName("gbylrttlocxgoknc")
    public suspend fun properties(`value`: Map<String, ColumnSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of columns within the data table.
     */
    @JvmName("ugesgisjwuiyrgig")
    public suspend fun properties(
        vararg
        argument: Pair<String, suspend ColumnSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ColumnSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values The set of columns within the data table.
     */
    @JvmName("mjfewvwnlyixyrkc")
    public fun properties(vararg values: Pair<String, ColumnSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Swagger schema title.
     */
    @JvmName("vsqibiximaygmilp")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The type of the entity described in swagger.
     */
    @JvmName("qxkkhtactvnsoesv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TableSpecificationArgs = TableSpecificationArgs(
        description = description,
        format = format,
        properties = properties,
        title = title,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
