@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.WebServicePropertiesForGraphArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties specific to a Graph based web service.
 * @property assets Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
 * @property commitmentPlan Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
 * @property description The description of the web service.
 * @property diagnostics Settings controlling the diagnostics traces collection for the web service.
 * @property exampleRequest Defines sample input data for one or more of the service's inputs.
 * @property exposeSampleData When set to true, sample data is included in the web service's swagger definition. The default value is true.
 * @property input Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
 * @property keys Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
 * @property machineLearningWorkspace Specifies the Machine Learning workspace containing the experiment that is source for the web service.
 * @property output Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
 * @property package The definition of the graph package making up this web service.
 * @property packageType Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
 * Expected value is 'Graph'.
 * @property parameters The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
 * @property payloadsInBlobStorage When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
 * @property payloadsLocation The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
 * @property readOnly When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
 * @property realtimeConfiguration Contains the configuration settings for the web service endpoint.
 * @property storageAccount Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
 * @property title The title of the web service.
 */
public data class WebServicePropertiesForGraphArgs(
    public val assets: Output<Map<String, AssetItemArgs>>? = null,
    public val commitmentPlan: Output<CommitmentPlanArgs>? = null,
    public val description: Output<String>? = null,
    public val diagnostics: Output<DiagnosticsConfigurationArgs>? = null,
    public val exampleRequest: Output<ExampleRequestArgs>? = null,
    public val exposeSampleData: Output<Boolean>? = null,
    public val input: Output<ServiceInputOutputSpecificationArgs>? = null,
    public val keys: Output<WebServiceKeysArgs>? = null,
    public val machineLearningWorkspace: Output<MachineLearningWorkspaceArgs>? = null,
    public val output: Output<ServiceInputOutputSpecificationArgs>? = null,
    public val `package`: Output<GraphPackageArgs>? = null,
    public val packageType: Output<String>,
    public val parameters: Output<Map<String, WebServiceParameterArgs>>? = null,
    public val payloadsInBlobStorage: Output<Boolean>? = null,
    public val payloadsLocation: Output<BlobLocationArgs>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val realtimeConfiguration: Output<RealtimeConfigurationArgs>? = null,
    public val storageAccount: Output<StorageAccountArgs>? = null,
    public val title: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.WebServicePropertiesForGraphArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearning.inputs.WebServicePropertiesForGraphArgs =
        com.pulumi.azurenative.machinelearning.inputs.WebServicePropertiesForGraphArgs.builder()
            .assets(
                assets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .commitmentPlan(commitmentPlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .exampleRequest(exampleRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .exposeSampleData(exposeSampleData?.applyValue({ args0 -> args0 }))
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keys(keys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .machineLearningWorkspace(
                machineLearningWorkspace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .output(output?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .package_(`package`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageType(packageType.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .payloadsInBlobStorage(payloadsInBlobStorage?.applyValue({ args0 -> args0 }))
            .payloadsLocation(payloadsLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .realtimeConfiguration(
                realtimeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageAccount(storageAccount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebServicePropertiesForGraphArgs].
 */
@PulumiTagMarker
public class WebServicePropertiesForGraphArgsBuilder internal constructor() {
    private var assets: Output<Map<String, AssetItemArgs>>? = null

    private var commitmentPlan: Output<CommitmentPlanArgs>? = null

    private var description: Output<String>? = null

    private var diagnostics: Output<DiagnosticsConfigurationArgs>? = null

    private var exampleRequest: Output<ExampleRequestArgs>? = null

    private var exposeSampleData: Output<Boolean>? = null

    private var input: Output<ServiceInputOutputSpecificationArgs>? = null

    private var keys: Output<WebServiceKeysArgs>? = null

    private var machineLearningWorkspace: Output<MachineLearningWorkspaceArgs>? = null

    private var output: Output<ServiceInputOutputSpecificationArgs>? = null

    private var `package`: Output<GraphPackageArgs>? = null

    private var packageType: Output<String>? = null

    private var parameters: Output<Map<String, WebServiceParameterArgs>>? = null

    private var payloadsInBlobStorage: Output<Boolean>? = null

    private var payloadsLocation: Output<BlobLocationArgs>? = null

    private var readOnly: Output<Boolean>? = null

    private var realtimeConfiguration: Output<RealtimeConfigurationArgs>? = null

    private var storageAccount: Output<StorageAccountArgs>? = null

    private var title: Output<String>? = null

    /**
     * @param value Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
     */
    @JvmName("cpiytlbjnnbgudnp")
    public suspend fun assets(`value`: Output<Map<String, AssetItemArgs>>) {
        this.assets = value
    }

    /**
     * @param value Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
     */
    @JvmName("xcyihtchiccuaxup")
    public suspend fun commitmentPlan(`value`: Output<CommitmentPlanArgs>) {
        this.commitmentPlan = value
    }

    /**
     * @param value The description of the web service.
     */
    @JvmName("csktjspwtmnhoqtg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Settings controlling the diagnostics traces collection for the web service.
     */
    @JvmName("ivvfhngeobywpudi")
    public suspend fun diagnostics(`value`: Output<DiagnosticsConfigurationArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value Defines sample input data for one or more of the service's inputs.
     */
    @JvmName("akylxdqeoappmqkp")
    public suspend fun exampleRequest(`value`: Output<ExampleRequestArgs>) {
        this.exampleRequest = value
    }

    /**
     * @param value When set to true, sample data is included in the web service's swagger definition. The default value is true.
     */
    @JvmName("mxtosqtyoutnuxou")
    public suspend fun exposeSampleData(`value`: Output<Boolean>) {
        this.exposeSampleData = value
    }

    /**
     * @param value Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
     */
    @JvmName("limhtqrbbqnyidgp")
    public suspend fun input(`value`: Output<ServiceInputOutputSpecificationArgs>) {
        this.input = value
    }

    /**
     * @param value Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
     */
    @JvmName("dkqnrjuxjvitqhyc")
    public suspend fun keys(`value`: Output<WebServiceKeysArgs>) {
        this.keys = value
    }

    /**
     * @param value Specifies the Machine Learning workspace containing the experiment that is source for the web service.
     */
    @JvmName("ocbmvfytybjxyyrs")
    public suspend fun machineLearningWorkspace(`value`: Output<MachineLearningWorkspaceArgs>) {
        this.machineLearningWorkspace = value
    }

    /**
     * @param value Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
     */
    @JvmName("vxhqbfwfjyaysbqs")
    public suspend fun output(`value`: Output<ServiceInputOutputSpecificationArgs>) {
        this.output = value
    }

    /**
     * @param value The definition of the graph package making up this web service.
     */
    @JvmName("eambcjmwnfjrxlik")
    public suspend fun `package`(`value`: Output<GraphPackageArgs>) {
        this.`package` = value
    }

    /**
     * @param value Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
     * Expected value is 'Graph'.
     */
    @JvmName("eutpscrhwrsspsrn")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
     */
    @JvmName("vpsaeiqqsnrxoyeg")
    public suspend fun parameters(`value`: Output<Map<String, WebServiceParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
     */
    @JvmName("ywygyhuxpqgxovss")
    public suspend fun payloadsInBlobStorage(`value`: Output<Boolean>) {
        this.payloadsInBlobStorage = value
    }

    /**
     * @param value The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
     */
    @JvmName("xjwxidvtitkevckl")
    public suspend fun payloadsLocation(`value`: Output<BlobLocationArgs>) {
        this.payloadsLocation = value
    }

    /**
     * @param value When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
     */
    @JvmName("gldyydjkubexdhps")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Contains the configuration settings for the web service endpoint.
     */
    @JvmName("jtbndvcxtmjpasdd")
    public suspend fun realtimeConfiguration(`value`: Output<RealtimeConfigurationArgs>) {
        this.realtimeConfiguration = value
    }

    /**
     * @param value Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
     */
    @JvmName("adlawevdvuxxkbpd")
    public suspend fun storageAccount(`value`: Output<StorageAccountArgs>) {
        this.storageAccount = value
    }

    /**
     * @param value The title of the web service.
     */
    @JvmName("mufrwtponnsppalc")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
     */
    @JvmName("sjwkqtdxcpoqkbxf")
    public suspend fun assets(`value`: Map<String, AssetItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assets = mapped
    }

    /**
     * @param argument Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
     */
    @JvmName("dxcbdfuueqikjpsi")
    public suspend fun assets(
        vararg
        argument: Pair<String, suspend AssetItemArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AssetItemArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.assets = mapped
    }

    /**
     * @param values Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
     */
    @JvmName("gagtyflnbdkwtjon")
    public fun assets(vararg values: Pair<String, AssetItemArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assets = mapped
    }

    /**
     * @param value Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
     */
    @JvmName("tuiolnfygdhgcleu")
    public suspend fun commitmentPlan(`value`: CommitmentPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentPlan = mapped
    }

    /**
     * @param argument Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
     */
    @JvmName("nvutlcbikxynubar")
    public suspend fun commitmentPlan(argument: suspend CommitmentPlanArgsBuilder.() -> Unit) {
        val toBeMapped = CommitmentPlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.commitmentPlan = mapped
    }

    /**
     * @param value The description of the web service.
     */
    @JvmName("kqqhbaloswocqeyc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Settings controlling the diagnostics traces collection for the web service.
     */
    @JvmName("lpgssexqmipgwqgi")
    public suspend fun diagnostics(`value`: DiagnosticsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument Settings controlling the diagnostics traces collection for the web service.
     */
    @JvmName("ytqjekrrqdfxcbwv")
    public suspend fun diagnostics(argument: suspend DiagnosticsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value Defines sample input data for one or more of the service's inputs.
     */
    @JvmName("jeappyrxqronvdqu")
    public suspend fun exampleRequest(`value`: ExampleRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exampleRequest = mapped
    }

    /**
     * @param argument Defines sample input data for one or more of the service's inputs.
     */
    @JvmName("diwuvtsendkflwki")
    public suspend fun exampleRequest(argument: suspend ExampleRequestArgsBuilder.() -> Unit) {
        val toBeMapped = ExampleRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exampleRequest = mapped
    }

    /**
     * @param value When set to true, sample data is included in the web service's swagger definition. The default value is true.
     */
    @JvmName("iejskdligvnlrnkp")
    public suspend fun exposeSampleData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeSampleData = mapped
    }

    /**
     * @param value Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
     */
    @JvmName("ewkxfgwsrqlwwjvl")
    public suspend fun input(`value`: ServiceInputOutputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
     */
    @JvmName("vsjtivuwhojquqft")
    public suspend
    fun input(argument: suspend ServiceInputOutputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceInputOutputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
     */
    @JvmName("irckpsnbwrrukalj")
    public suspend fun keys(`value`: WebServiceKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param argument Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
     */
    @JvmName("uqjpnxuhvkecpyie")
    public suspend fun keys(argument: suspend WebServiceKeysArgsBuilder.() -> Unit) {
        val toBeMapped = WebServiceKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param value Specifies the Machine Learning workspace containing the experiment that is source for the web service.
     */
    @JvmName("lrsbdumxpkamaexu")
    public suspend fun machineLearningWorkspace(`value`: MachineLearningWorkspaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineLearningWorkspace = mapped
    }

    /**
     * @param argument Specifies the Machine Learning workspace containing the experiment that is source for the web service.
     */
    @JvmName("yuhfyuedotkuhkgu")
    public suspend
    fun machineLearningWorkspace(argument: suspend MachineLearningWorkspaceArgsBuilder.() -> Unit) {
        val toBeMapped = MachineLearningWorkspaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.machineLearningWorkspace = mapped
    }

    /**
     * @param value Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
     */
    @JvmName("xsebhwokqfahfosx")
    public suspend fun output(`value`: ServiceInputOutputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param argument Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
     */
    @JvmName("dyfxiagawsnhorsk")
    public suspend
    fun output(argument: suspend ServiceInputOutputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceInputOutputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.output = mapped
    }

    /**
     * @param value The definition of the graph package making up this web service.
     */
    @JvmName("wlnrsujjuycifgpi")
    public suspend fun `package`(`value`: GraphPackageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`package` = mapped
    }

    /**
     * @param argument The definition of the graph package making up this web service.
     */
    @JvmName("ypghhmbptrvhunch")
    public suspend fun `package`(argument: suspend GraphPackageArgsBuilder.() -> Unit) {
        val toBeMapped = GraphPackageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`package` = mapped
    }

    /**
     * @param value Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
     * Expected value is 'Graph'.
     */
    @JvmName("jujepslhsqngdfem")
    public suspend fun packageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
     */
    @JvmName("wukmcgshebyupwtn")
    public suspend fun parameters(`value`: Map<String, WebServiceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
     */
    @JvmName("sidxmcnnscreospn")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend WebServiceParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                WebServiceParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
     */
    @JvmName("ufxsylgatyolohec")
    public fun parameters(vararg values: Pair<String, WebServiceParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
     */
    @JvmName("rtsvyafejhssirlw")
    public suspend fun payloadsInBlobStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadsInBlobStorage = mapped
    }

    /**
     * @param value The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
     */
    @JvmName("wmbjrnqslhmwufle")
    public suspend fun payloadsLocation(`value`: BlobLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadsLocation = mapped
    }

    /**
     * @param argument The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
     */
    @JvmName("luumpaolmvnelebp")
    public suspend fun payloadsLocation(argument: suspend BlobLocationArgsBuilder.() -> Unit) {
        val toBeMapped = BlobLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.payloadsLocation = mapped
    }

    /**
     * @param value When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
     */
    @JvmName("xvhgylvlcpmnmqqn")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Contains the configuration settings for the web service endpoint.
     */
    @JvmName("kdgxpdobxlkpnnlj")
    public suspend fun realtimeConfiguration(`value`: RealtimeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realtimeConfiguration = mapped
    }

    /**
     * @param argument Contains the configuration settings for the web service endpoint.
     */
    @JvmName("ebombfmiylswtamy")
    public suspend
    fun realtimeConfiguration(argument: suspend RealtimeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RealtimeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.realtimeConfiguration = mapped
    }

    /**
     * @param value Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
     */
    @JvmName("sefwdwopcalwpael")
    public suspend fun storageAccount(`value`: StorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param argument Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
     */
    @JvmName("jjcfwotjmawgswxi")
    public suspend fun storageAccount(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccount = mapped
    }

    /**
     * @param value The title of the web service.
     */
    @JvmName("rgiomkwqggnpclwv")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): WebServicePropertiesForGraphArgs = WebServicePropertiesForGraphArgs(
        assets = assets,
        commitmentPlan = commitmentPlan,
        description = description,
        diagnostics = diagnostics,
        exampleRequest = exampleRequest,
        exposeSampleData = exposeSampleData,
        input = input,
        keys = keys,
        machineLearningWorkspace = machineLearningWorkspace,
        output = output,
        `package` = `package`,
        packageType = packageType ?: throw PulumiNullFieldException("packageType"),
        parameters = parameters,
        payloadsInBlobStorage = payloadsInBlobStorage,
        payloadsLocation = payloadsLocation,
        readOnly = readOnly,
        realtimeConfiguration = realtimeConfiguration,
        storageAccount = storageAccount,
        title = title,
    )
}
