@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure ML commitment plan resource.
 * @property etag An entity tag used to enforce optimistic concurrency.
 * @property id Resource Id.
 * @property location Resource location.
 * @property name Resource name.
 * @property properties The commitment plan properties.
 * @property sku The commitment plan SKU.
 * @property tags User-defined tags for the resource.
 * @property type Resource type.
 */
public data class GetCommitmentPlanResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: CommitmentPlanPropertiesResponse,
    public val sku: ResourceSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GetCommitmentPlanResult):
            GetCommitmentPlanResult = GetCommitmentPlanResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.machinelearning.kotlin.outputs.CommitmentPlanPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
