@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Represents the quantity a commitment plan provides of a metered resource.
 * @property allowance The quantity added to the commitment plan at an interval specified by its allowance frequency.
 * @property amount The quantity available to the plan the last time usage was calculated.
 * @property includedQuantityMeter The Azure meter for usage against included quantities.
 * @property overageMeter The Azure meter for usage which exceeds included quantities.
 */
public data class PlanQuantityResponse(
    public val allowance: Double,
    public val amount: Double,
    public val includedQuantityMeter: String,
    public val overageMeter: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.PlanQuantityResponse):
            PlanQuantityResponse = PlanQuantityResponse(
            allowance = javaType.allowance(),
            amount = javaType.amount(),
            includedQuantityMeter = javaType.includedQuantityMeter(),
            overageMeter = javaType.overageMeter(),
        )
    }
}
