@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties specific to a Graph based web service.
 * @property assets Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
 * @property commitmentPlan Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
 * @property createdOn Read Only: The date and time when the web service was created.
 * @property description The description of the web service.
 * @property diagnostics Settings controlling the diagnostics traces collection for the web service.
 * @property exampleRequest Defines sample input data for one or more of the service's inputs.
 * @property exposeSampleData When set to true, sample data is included in the web service's swagger definition. The default value is true.
 * @property input Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
 * @property keys Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
 * @property machineLearningWorkspace Specifies the Machine Learning workspace containing the experiment that is source for the web service.
 * @property modifiedOn Read Only: The date and time when the web service was last modified.
 * @property output Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
 * @property package The definition of the graph package making up this web service.
 * @property packageType Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
 * Expected value is 'Graph'.
 * @property parameters The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
 * @property payloadsInBlobStorage When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
 * @property payloadsLocation The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
 * @property provisioningState Read Only: The provision state of the web service. Valid values are Unknown, Provisioning, Succeeded, and Failed.
 * @property readOnly When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
 * @property realtimeConfiguration Contains the configuration settings for the web service endpoint.
 * @property storageAccount Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
 * @property swaggerLocation Read Only: Contains the URI of the swagger spec associated with this web service.
 * @property title The title of the web service.
 */
public data class WebServicePropertiesForGraphResponse(
    public val assets: Map<String, AssetItemResponse>? = null,
    public val commitmentPlan: CommitmentPlanResponse? = null,
    public val createdOn: String,
    public val description: String? = null,
    public val diagnostics: DiagnosticsConfigurationResponse? = null,
    public val exampleRequest: ExampleRequestResponse? = null,
    public val exposeSampleData: Boolean? = null,
    public val input: ServiceInputOutputSpecificationResponse? = null,
    public val keys: WebServiceKeysResponse? = null,
    public val machineLearningWorkspace: MachineLearningWorkspaceResponse? = null,
    public val modifiedOn: String,
    public val output: ServiceInputOutputSpecificationResponse? = null,
    public val `package`: GraphPackageResponse? = null,
    public val packageType: String,
    public val parameters: Map<String, WebServiceParameterResponse>? = null,
    public val payloadsInBlobStorage: Boolean? = null,
    public val payloadsLocation: BlobLocationResponse? = null,
    public val provisioningState: String,
    public val readOnly: Boolean? = null,
    public val realtimeConfiguration: RealtimeConfigurationResponse? = null,
    public val storageAccount: StorageAccountResponse? = null,
    public val swaggerLocation: String,
    public val title: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.WebServicePropertiesForGraphResponse):
            WebServicePropertiesForGraphResponse = WebServicePropertiesForGraphResponse(
            assets = javaType.assets().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.AssetItemResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            commitmentPlan = javaType.commitmentPlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.CommitmentPlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdOn = javaType.createdOn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.DiagnosticsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exampleRequest = javaType.exampleRequest().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ExampleRequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exposeSampleData = javaType.exposeSampleData().map({ args0 -> args0 }).orElse(null),
            input = javaType.input().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ServiceInputOutputSpecificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keys = javaType.keys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServiceKeysResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            machineLearningWorkspace = javaType.machineLearningWorkspace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.MachineLearningWorkspaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modifiedOn = javaType.modifiedOn(),
            output = javaType.output().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ServiceInputOutputSpecificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `package` = javaType.package_().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.GraphPackageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            packageType = javaType.packageType(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServiceParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            payloadsInBlobStorage = javaType.payloadsInBlobStorage().map({ args0 -> args0 }).orElse(null),
            payloadsLocation = javaType.payloadsLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.BlobLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            realtimeConfiguration = javaType.realtimeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.RealtimeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccount = javaType.storageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            swaggerLocation = javaType.swaggerLocation(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
