@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin

import com.pulumi.azurenative.machinelearningcompute.MachinelearningcomputeFunctions.getOperationalizationClusterPlain
import com.pulumi.azurenative.machinelearningcompute.MachinelearningcomputeFunctions.listOperationalizationClusterKeysPlain
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.GetOperationalizationClusterPlainArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.GetOperationalizationClusterPlainArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.ListOperationalizationClusterKeysPlainArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.ListOperationalizationClusterKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.GetOperationalizationClusterResult
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ListOperationalizationClusterKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.GetOperationalizationClusterResult.Companion.toKotlin as getOperationalizationClusterResultToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ListOperationalizationClusterKeysResult.Companion.toKotlin as listOperationalizationClusterKeysResultToKotlin

public object MachinelearningcomputeFunctions {
    /**
     * Gets the operationalization cluster resource view. Note that the credentials are not returned by this call. Call ListKeys to get them.
     * Azure REST API version: 2017-08-01-preview.
     * Other available API versions: 2017-06-01-preview.
     * @param argument null
     * @return Instance of an Azure ML Operationalization Cluster resource.
     */
    public suspend fun getOperationalizationCluster(argument: GetOperationalizationClusterPlainArgs):
        GetOperationalizationClusterResult =
        getOperationalizationClusterResultToKotlin(getOperationalizationClusterPlain(argument.toJava()).await())

    /**
     * @see [getOperationalizationCluster].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName Name of the resource group in which the cluster is located.
     * @return Instance of an Azure ML Operationalization Cluster resource.
     */
    public suspend fun getOperationalizationCluster(clusterName: String, resourceGroupName: String):
        GetOperationalizationClusterResult {
        val argument = GetOperationalizationClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getOperationalizationClusterResultToKotlin(getOperationalizationClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getOperationalizationCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningcompute&#46;kotlin&#46;inputs&#46;GetOperationalizationClusterPlainArgs].
     * @return Instance of an Azure ML Operationalization Cluster resource.
     */
    public suspend
    fun getOperationalizationCluster(argument: suspend GetOperationalizationClusterPlainArgsBuilder.() -> Unit):
        GetOperationalizationClusterResult {
        val builder = GetOperationalizationClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOperationalizationClusterResultToKotlin(getOperationalizationClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the credentials for the specified cluster such as Storage, ACR and ACS credentials. This is a long running operation because it fetches keys from dependencies.
     * Azure REST API version: 2017-08-01-preview.
     * Other available API versions: 2017-06-01-preview.
     * @param argument null
     * @return Credentials to resources in the cluster.
     */
    public suspend
    fun listOperationalizationClusterKeys(argument: ListOperationalizationClusterKeysPlainArgs):
        ListOperationalizationClusterKeysResult =
        listOperationalizationClusterKeysResultToKotlin(listOperationalizationClusterKeysPlain(argument.toJava()).await())

    /**
     * @see [listOperationalizationClusterKeys].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName Name of the resource group in which the cluster is located.
     * @return Credentials to resources in the cluster.
     */
    public suspend fun listOperationalizationClusterKeys(
        clusterName: String,
        resourceGroupName: String,
    ): ListOperationalizationClusterKeysResult {
        val argument = ListOperationalizationClusterKeysPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return listOperationalizationClusterKeysResultToKotlin(listOperationalizationClusterKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listOperationalizationClusterKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningcompute&#46;kotlin&#46;inputs&#46;ListOperationalizationClusterKeysPlainArgs].
     * @return Credentials to resources in the cluster.
     */
    public suspend
    fun listOperationalizationClusterKeys(argument: suspend ListOperationalizationClusterKeysPlainArgsBuilder.() -> Unit):
        ListOperationalizationClusterKeysResult {
        val builder = ListOperationalizationClusterKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOperationalizationClusterKeysResultToKotlin(listOperationalizationClusterKeysPlain(builtArgument.toJava()).await())
    }
}
