@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.KubernetesClusterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kubernetes cluster specific properties
 * @property servicePrincipal The Azure Service Principal used by Kubernetes
 */
public data class KubernetesClusterPropertiesArgs(
    public val servicePrincipal: Output<ServicePrincipalPropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.KubernetesClusterPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.KubernetesClusterPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.KubernetesClusterPropertiesArgs.builder()
            .servicePrincipal(
                servicePrincipal?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KubernetesClusterPropertiesArgs].
 */
@PulumiTagMarker
public class KubernetesClusterPropertiesArgsBuilder internal constructor() {
    private var servicePrincipal: Output<ServicePrincipalPropertiesArgs>? = null

    /**
     * @param value The Azure Service Principal used by Kubernetes
     */
    @JvmName("ebqdtdptmlepltrv")
    public suspend fun servicePrincipal(`value`: Output<ServicePrincipalPropertiesArgs>) {
        this.servicePrincipal = value
    }

    /**
     * @param value The Azure Service Principal used by Kubernetes
     */
    @JvmName("fgsmyubhpoirdlyn")
    public suspend fun servicePrincipal(`value`: ServicePrincipalPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipal = mapped
    }

    /**
     * @param argument The Azure Service Principal used by Kubernetes
     */
    @JvmName("mbmchwtjctcnqypq")
    public suspend
    fun servicePrincipal(argument: suspend ServicePrincipalPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipal = mapped
    }

    internal fun build(): KubernetesClusterPropertiesArgs = KubernetesClusterPropertiesArgs(
        servicePrincipal = servicePrincipal,
    )
}
